/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.recipes;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.lpcamors.optical.blocks.optical_source.BeamHelper;
import net.lpcamors.optical.config.COConfigs;
import net.lpcamors.optical.data.IndexedEnum;
import net.lpcamors.optical.recipes.FocusingRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class FocusingRecipeParams
extends ProcessingRecipeBuilder.ProcessingRecipeParams {
    private final ResourceLocation id;

    public FocusingRecipeParams(Ingredient ingredient, ItemStack itemStack, ResourceLocation id) {
        this(ingredient, new ProcessingOutput(itemStack, 1.0f), id);
    }

    public FocusingRecipeParams(Ingredient ingredient, ProcessingOutput processingOutput, ResourceLocation id) {
        this(List.of(ingredient), List.of(processingOutput), id);
    }

    public FocusingRecipeParams(List<Ingredient> ingredient, List<ProcessingOutput> processingOutput, ResourceLocation id) {
        this(id);
        this.ingredients.addAll(ingredient);
        this.results.addAll(processingOutput);
    }

    public FocusingRecipeParams(ResourceLocation id) {
        super(id);
        this.id = id;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public NonNullList<ProcessingOutput> getOutputs() {
        return this.results;
    }

    private static List<ProcessingOutput> append(ProcessingOutput processingOutput, List<ProcessingOutput> p) {
        ArrayList<ProcessingOutput> p0 = new ArrayList<ProcessingOutput>();
        p0.add(processingOutput);
        p0.addAll(p);
        return p0;
    }

    static ResourceLocation id(Recipe<?> r, BeamTypeCondition beamTypeCondition) {
        return new ResourceLocation("create_optical", r.m_6423_().m_135815_() + "_focusing_" + beamTypeCondition.name().toLowerCase());
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public static Boolean smokingPredicate(Level level, ItemStack itemStack) {
        RecipeWrapper recipeWrapper = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
        recipeWrapper.m_6836_(0, itemStack);
        Optional recipe = level.m_7465_().m_44015_(RecipeType.f_44110_, (Container)recipeWrapper, level);
        if (recipe.isPresent()) {
            return true;
        }
        return false;
    }

    public static ItemStack smokingMap(Level level, ItemStack itemStack) {
        RecipeWrapper recipeWrapper = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
        recipeWrapper.m_6836_(0, itemStack);
        Optional recipe = level.m_7465_().m_44015_(RecipeType.f_44110_, (Container)recipeWrapper, level);
        return recipe.map(smokingRecipe -> smokingRecipe.m_8043_(level.m_9598_())).orElse(ItemStack.f_41583_);
    }

    public static enum BeamTypeCondition {
        RADIO(0, 6192150),
        MICROWAVE(1, 8991416),
        VISIBLE(2, 15237888),
        GAMMA(3, 6067176),
        NONE(4, 0xFFFFFF);

        public static final IndexedEnum<BeamTypeCondition> INDEXED;
        private final int id;
        private final int color;

        private BeamTypeCondition(int id, int color) {
            this.id = id;
            this.color = color;
        }

        public int getId() {
            return this.id;
        }

        public boolean test(BeamHelper.BeamType beamType) {
            return this.id == 4 || beamType.id == this.id;
        }

        public static BeamTypeCondition getFromType(BeamHelper.BeamType b) {
            return Arrays.stream(BeamTypeCondition.values()).filter(beamTypeCondition1 -> beamTypeCondition1.test(b) && beamTypeCondition1.id != 4).toList().get(0);
        }

        public int getColor() {
            return this.color;
        }

        public String getTranslationKey() {
            return "required_beam_type." + this.name().toLowerCase();
        }

        static {
            INDEXED = new IndexedEnum(true, (Enum[])BeamTypeCondition.values());
        }
    }

    public static enum BeamTypeConditionProfile {
        SMOKING(RecipeType.f_44110_, registryAccess -> recipe -> FocusingRecipe.microwave(BeamTypeConditionProfile.getFromConfig(List.of((Ingredient)recipe.m_7527_().get(0)), recipe.m_8043_(registryAccess), Items.f_42414_.m_7968_(), COConfigs.server().recipes.focusingSmokingFailedOutputProbability.getF(), FocusingRecipeParams.id(recipe, BeamTypeCondition.MICROWAVE)))),
        ADD_COLOR(BeamTypeConditionProfile::colorItems, registryAccess -> recipe -> {
            Ingredient complement;
            Ingredient dye;
            if (((Ingredient)recipe.m_7527_().get(0)).m_43908_()[0].m_41720_() instanceof DyeItem) {
                dye = (Ingredient)recipe.m_7527_().get(0);
                complement = (Ingredient)recipe.m_7527_().get(1);
            } else {
                dye = (Ingredient)recipe.m_7527_().get(1);
                complement = (Ingredient)recipe.m_7527_().get(0);
            }
            return FocusingRecipe.visible(BeamTypeConditionProfile.getFromConfig(List.of(complement, dye), recipe.m_8043_(registryAccess), Items.f_42414_.m_7968_(), COConfigs.server().recipes.focusingColoringFailedOutputProbability.getF(), FocusingRecipeParams.id(recipe, BeamTypeCondition.VISIBLE)));
        }),
        SANDPAPER(AllRecipeTypes.SANDPAPER_POLISHING.getType(), registryAccess -> recipe -> FocusingRecipe.visible(BeamTypeConditionProfile.getFromConfig(List.of((Ingredient)recipe.m_7527_().get(0), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41830_})), recipe.m_8043_(registryAccess), Items.f_42414_.m_7968_(), COConfigs.server().recipes.focusingSandingFailedOutputProbability.getF(), FocusingRecipeParams.id(recipe, BeamTypeCondition.VISIBLE))));

        private final Predicate<Recipe<?>> recipePredicate;
        private final Function<RegistryAccess, Function<Recipe<?>, FocusingRecipe>> converter;
        private static final List<FocusingRecipe> RECIPES;

        public static FocusingRecipeParams getFromConfig(List<Ingredient> ingredients, ItemStack output, ItemStack failOutput, float failChance, ResourceLocation locName) {
            ArrayList<ProcessingOutput> outputs = new ArrayList<ProcessingOutput>();
            outputs.add(new ProcessingOutput(output, 1.0f - failChance));
            if ((double)failChance > 0.0) {
                outputs.add(new ProcessingOutput(failOutput, failChance));
            }
            return new FocusingRecipeParams(ingredients, outputs, locName);
        }

        private static boolean colorItems(Recipe<?> r) {
            return r.m_7527_().size() == 2 && ((Ingredient)r.m_7527_().get(0)).m_43908_()[0].m_41720_() instanceof DyeItem ^ ((Ingredient)r.m_7527_().get(1)).m_43908_()[0].m_41720_() instanceof DyeItem;
        }

        private static List<ProcessingOutput> outputCharcoal(ItemStack item, float successChance) {
            return List.of(new ProcessingOutput(item, successChance), new ProcessingOutput(new ItemStack((ItemLike)Items.f_42414_), 1.0f - successChance));
        }

        private BeamTypeConditionProfile(RecipeType<?> recipeType, Function<RegistryAccess, Function<Recipe<?>, FocusingRecipe>> converter) {
            this((Recipe<?> r) -> r.m_6671_().equals(recipeType), converter);
        }

        private BeamTypeConditionProfile(Predicate<Recipe<?>> recipePredicate, Function<RegistryAccess, Function<Recipe<?>, FocusingRecipe>> converter) {
            this.recipePredicate = recipePredicate;
            this.converter = converter;
        }

        public Function<Recipe<?>, FocusingRecipe> getConverter(RegistryAccess registryAccess) {
            return this.converter.apply(registryAccess);
        }

        public Predicate<Recipe<?>> getRecipePredicate() {
            return this.recipePredicate;
        }

        public static void initializeRecipes(Level level) {
            if (!RECIPES.isEmpty()) {
                RECIPES.clear();
            }
            Arrays.stream(BeamTypeConditionProfile.values()).forEach(b -> level.m_7465_().m_44051_().forEach(recipe -> {
                if (b.recipePredicate.test((Recipe<?>)recipe)) {
                    RECIPES.add(b.getConverter(level.m_9598_()).apply((Recipe<?>)recipe));
                }
            }));
        }

        public Optional<FocusingRecipe> getRecipe(Level level, RecipeWrapper recipeWrapper, BeamHelper.BeamType b) {
            List<FocusingRecipe> focusingRecipes = RECIPES.stream().filter(r -> r.matches(recipeWrapper, level) && r.beamTypeCondition.test(b)).toList();
            return Optional.ofNullable(focusingRecipes.isEmpty() ? null : focusingRecipes.get(0));
        }

        public static boolean canBeProcessed(Level level, RecipeWrapper recipeWrapper, BeamHelper.BeamType b) {
            return BeamTypeConditionProfile.getRecipeFor(level, recipeWrapper, b).isPresent();
        }

        public static Optional<FocusingRecipe> getRecipeFor(Level level, RecipeWrapper recipeWrapper, BeamHelper.BeamType beamType) {
            List<FocusingRecipe> focusingRecipes = Arrays.stream(BeamTypeConditionProfile.values()).map(b -> b.getRecipe(level, recipeWrapper, beamType)).filter(Optional::isPresent).map(Optional::get).toList();
            return Optional.ofNullable(focusingRecipes.isEmpty() ? null : focusingRecipes.get(0));
        }

        static {
            RECIPES = new ArrayList<FocusingRecipe>();
        }
    }
}

