/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.lpcamors.optical.CORecipeTypes;
import net.lpcamors.optical.blocks.COBlocks;
import net.lpcamors.optical.compat.jei.FocusingAssemblySubcategory;
import net.lpcamors.optical.data.COLang;
import net.lpcamors.optical.recipes.FocusingRecipeParams;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class FocusingRecipe
extends ProcessingRecipe<RecipeWrapper>
implements IAssemblyRecipe {
    private static final String REQUIRED_BEAM_TYPE_KEY = "required_beam_type";
    public FocusingRecipeParams.BeamTypeCondition beamTypeCondition = FocusingRecipeParams.BeamTypeCondition.NONE;

    public static FocusingRecipe radio(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        FocusingRecipe f = new FocusingRecipe(params);
        f.beamTypeCondition = FocusingRecipeParams.BeamTypeCondition.RADIO;
        return f;
    }

    public static FocusingRecipe microwave(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        FocusingRecipe f = new FocusingRecipe(params);
        f.beamTypeCondition = FocusingRecipeParams.BeamTypeCondition.MICROWAVE;
        return f;
    }

    public static FocusingRecipe visible(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        FocusingRecipe f = new FocusingRecipe(params);
        f.beamTypeCondition = FocusingRecipeParams.BeamTypeCondition.VISIBLE;
        return f;
    }

    public static FocusingRecipe gamma(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        FocusingRecipe f = new FocusingRecipe(params);
        f.beamTypeCondition = FocusingRecipeParams.BeamTypeCondition.GAMMA;
        return f;
    }

    public static FocusingRecipe none(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        FocusingRecipe f = new FocusingRecipe(params);
        f.beamTypeCondition = FocusingRecipeParams.BeamTypeCondition.NONE;
        return f;
    }

    public FocusingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)CORecipeTypes.FOCUSING, params);
    }

    protected int getMaxInputCount() {
        return 2;
    }

    protected int getMaxOutputCount() {
        return 2;
    }

    public Component getDescriptionForAssembly() {
        return COLang.Prefixes.JEI.translate("focusing.sequence." + this.beamTypeCondition.getId(), new Object[0]);
    }

    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)COBlocks.BEAM_FOCUSER.get());
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
        if (this.ingredients.size() > 1) {
            list.add((Ingredient)this.m_7527_().get(1));
        }
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> FocusingAssemblySubcategory::new;
    }

    public boolean matches(RecipeWrapper p_44002_, Level p_44003_) {
        if (p_44002_.m_7983_()) {
            return false;
        }
        boolean f = this.getIngredient().test(p_44002_.m_8020_(0));
        if (p_44002_.m_6643_() > 1) {
            f &= this.getSecondIngredient().test(p_44002_.m_8020_(1));
        }
        return f;
    }

    public Ingredient getIngredient() {
        return (Ingredient)this.m_7527_().get(0);
    }

    public Ingredient getSecondIngredient() {
        if (this.ingredients.size() > 1) {
            return (Ingredient)this.m_7527_().get(1);
        }
        return Ingredient.f_43901_;
    }

    public ProcessingOutput getOutput() {
        return (ProcessingOutput)this.results.get(0);
    }

    public int getProcessingDuration() {
        int i = super.getProcessingDuration();
        return i == 0 ? 40 : i;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public FocusingRecipeParams.BeamTypeCondition getRequiredBeamType() {
        return this.beamTypeCondition;
    }

    protected FocusingRecipeParams.BeamTypeCondition readRequiredBeamType(JsonObject jsonObject) {
        JsonElement got;
        FocusingRecipeParams.BeamTypeCondition parsed;
        if (jsonObject.has(REQUIRED_BEAM_TYPE_KEY) && (parsed = FocusingRecipeParams.BeamTypeCondition.INDEXED.fromJson(got = jsonObject.get(REQUIRED_BEAM_TYPE_KEY))) != null) {
            return parsed;
        }
        return FocusingRecipeParams.BeamTypeCondition.NONE;
    }

    protected FocusingRecipeParams.BeamTypeCondition readRequiredBeamType(FriendlyByteBuf buffer) {
        int i = buffer.readInt();
        if (i >= 0 && i < FocusingRecipeParams.BeamTypeCondition.values().length) {
            return FocusingRecipeParams.BeamTypeCondition.values()[i];
        }
        return FocusingRecipeParams.BeamTypeCondition.NONE;
    }

    public void writeAdditional(JsonObject json) {
        super.writeAdditional(json);
        json.addProperty(REQUIRED_BEAM_TYPE_KEY, (Number)this.getRequiredBeamType().getId());
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        super.writeAdditional(buffer);
        buffer.writeInt(this.getRequiredBeamType().getId());
    }

    public void readAdditional(JsonObject json) {
        super.readAdditional(json);
        this.beamTypeCondition = this.readRequiredBeamType(json);
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        super.readAdditional(buffer);
        this.beamTypeCondition = this.readRequiredBeamType(buffer);
    }
}

