/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class IndexedEnum<T extends Enum<T>> {
    public final boolean autoLowerCase;
    public final Map<String, T> named;
    public final List<T> indexed;

    public IndexedEnum(boolean autoLowerCase, T ... values) {
        this.autoLowerCase = autoLowerCase;
        this.named = ImmutableMap.builder().putAll(Arrays.stream(values).map(e -> Map.entry(this.processName(e.name()), e)).toList()).build();
        this.indexed = ImmutableList.copyOf((Object[])values);
    }

    private String processName(String name) {
        if (this.autoLowerCase) {
            return name.toLowerCase(Locale.ROOT);
        }
        return name;
    }

    public boolean indexInBound(int index) {
        return index >= 0 && index < this.indexed.size();
    }

    public T byIndex(int index) {
        if (!this.indexInBound(index)) {
            return null;
        }
        return (T)((Enum)this.indexed.get(index));
    }

    public T byName(String name) {
        return (T)((Enum)this.named.get(this.processName(name)));
    }

    public T fromJson(JsonElement element) {
        if (!(element instanceof JsonPrimitive)) {
            return null;
        }
        JsonPrimitive primitive = (JsonPrimitive)element;
        if (primitive.isNumber()) {
            return this.byIndex(primitive.getAsInt());
        }
        if (primitive.isString()) {
            return this.byName(primitive.getAsString());
        }
        return null;
    }
}

