/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.blocks.optical_source;

import com.mojang.datafixers.util.Pair;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.math.VecHelper;
import net.lpcamors.optical.blocks.IBeamSource;
import net.lpcamors.optical.blocks.optical_source.BeamHelper;
import net.lpcamors.optical.blocks.optical_source.OpticalSourceBlock;
import net.lpcamors.optical.data.COLang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OpticalSourceBlockEntity
extends KineticBlockEntity
implements IBeamSource {
    private Map<Pair<Vec3i, Vec3i>, BeamHelper.BeamProperties> beamPropertiesMap = new HashMap<Pair<Vec3i, Vec3i>, BeamHelper.BeamProperties>();
    private List<BlockPos> iBeamReceiverBlockPos = new ArrayList<BlockPos>();
    private List<BlockPos> toIBeamReceiverBlockPos = new ArrayList<BlockPos>();
    private ScrollOptionBehaviour<BeamHelper.BeamPolarization> polarization;
    private int tickCount = 0;

    public OpticalSourceBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.polarization = new ScrollOptionBehaviour(BeamHelper.BeamPolarization.class, (Component)Lang.builder((String)"tooltip").translate("create_optical.gui.behaviour.optical_source", new Object[0]).component(), (SmartBlockEntity)this, (ValueBoxTransform)new PolarizationValueBoxTransform());
        behaviours.add((BlockEntityBehaviour)this.polarization);
    }

    public void tick() {
        super.tick();
        ++this.tickCount;
        this.toIBeamReceiverBlockPos = new ArrayList<BlockPos>();
        this.beamPropertiesMap.clear();
        if (this.isActive()) {
            IBeamSource.propagateLinearBeamVar(this, this.m_58899_(), this.getInitialBeamProperties(), 0);
        }
        this.iBeamReceiverBlockPos = this.toIBeamReceiverBlockPos;
    }

    public boolean isActive() {
        return Math.abs(this.getSpeed()) > 0.0f;
    }

    @Override
    public BeamHelper.BeamProperties getInitialBeamProperties() {
        return new BeamHelper.BeamProperties(this.getIntensity(), (BeamHelper.BeamPolarization)this.polarization.get(), (Direction)this.m_58900_().m_61143_(OpticalSourceBlock.HORIZONTAL_FACING), BeamHelper.BeamProperties.spinBySpeed(this.getSpeed()), BeamHelper.BeamType.getTypeBySpeed(this.speed));
    }

    public ScrollOptionBehaviour<BeamHelper.BeamPolarization> getPolarization() {
        return this.polarization;
    }

    public float getIntensity() {
        return BeamHelper.BeamProperties.intensityBySpeed(this.getSpeed());
    }

    @Override
    public void addToBeamBlocks(Vec3i vec, Vec3i vec1, BeamHelper.BeamProperties beamProperties) {
        this.beamPropertiesMap.put((Pair<Vec3i, Vec3i>)new Pair((Object)vec, (Object)vec1), beamProperties);
    }

    @Override
    public Map<Pair<Vec3i, Vec3i>, BeamHelper.BeamProperties> getBeamPropertiesMap() {
        return this.beamPropertiesMap;
    }

    @Override
    public boolean isDependent(BlockPos pos) {
        return this.iBeamReceiverBlockPos.contains(pos);
    }

    @Override
    public void addDependent(BlockPos pos) {
        this.toIBeamReceiverBlockPos.add(pos);
    }

    @Override
    public int getTickCount() {
        return this.tickCount;
    }

    @Override
    public boolean shouldRendererLaserBeam() {
        return this.getSpeed() != 0.0f && this.getInitialBeamProperties() != null && this.getInitialBeamProperties().isVisible() && !this.getBeamPropertiesMap().keySet().isEmpty();
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        ListTag listTag = new ListTag();
        this.iBeamReceiverBlockPos.forEach(pos -> listTag.add((Object)NbtUtils.m_129224_((BlockPos)pos)));
        compound.m_128365_("IBeamReceiverBlockPosList", (Tag)listTag);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        ListTag listTag;
        super.read(compound, clientPacket);
        if (compound.m_128441_("IBeamReceiverBlockPosList") && (listTag = (ListTag)compound.m_128423_("IBeamReceiverBlockPosList")) != null) {
            listTag.forEach(tag -> this.iBeamReceiverBlockPos.add(NbtUtils.m_129239_((CompoundTag)((CompoundTag)tag))));
        }
        if (!clientPacket) {
            return;
        }
        if (this.m_58898_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
        }
        if (!this.isVirtual()) {
            this.requestModelDataUpdate();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.builder((String)"tooltip").translate("create_optical.gui.goggles.beam_properties", new Object[0]).forGoggles(tooltip);
        if (Math.abs(this.getSpeed()) > 0.0f) {
            BeamHelper.BeamType beamType = this.getInitialBeamProperties().getType();
            Lang.builder((String)"").add(COLang.Prefixes.CREATE.translate("gui.goggles.beam_type", new Object[0]).m_130940_(ChatFormatting.GRAY)).forGoggles(tooltip);
            Lang.builder((String)"").add(COLang.Prefixes.CREATE.translate(beamType.getDescriptionId(), new Object[0]).m_130940_(ChatFormatting.AQUA)).forGoggles(tooltip, 1);
            Lang.builder((String)"").add(COLang.Prefixes.CREATE.translate("gui.goggles.propagation_range", new Object[0]).m_130940_(ChatFormatting.GRAY)).forGoggles(tooltip);
            Lang.builder((String)"").add(Component.m_237113_((String)(" " + beamType.getRange() + " blocks")).m_130940_(ChatFormatting.AQUA)).forGoggles(tooltip, 1);
        }
        BeamHelper.BeamPolarization beamPolarization = (BeamHelper.BeamPolarization)this.polarization.get();
        Lang.builder((String)"").add(COLang.Prefixes.CREATE.translate("gui.goggles.polarization", new Object[0]).m_130940_(ChatFormatting.GRAY)).forGoggles(tooltip);
        Lang.builder((String)"").add(COLang.Prefixes.CREATE.translate(beamPolarization.getTranslationKey(), new Object[0]).m_130946_(" " + beamPolarization.getsIcon()).m_130940_(ChatFormatting.AQUA)).forGoggles(tooltip, 1);
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    private static class PolarizationValueBoxTransform
    extends ValueBoxTransform.Sided {
        private PolarizationValueBoxTransform() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)6.0, (double)15.5);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            if (direction.m_122434_().m_122478_()) {
                return false;
            }
            return ((Direction)state.m_61143_(OpticalSourceBlock.HORIZONTAL_FACING)).m_122427_().m_122434_().equals((Object)direction.m_122434_());
        }

        public float getScale() {
            return 0.5f;
        }
    }
}

