/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.blocks.beam_focuser;

import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.List;
import java.util.Optional;
import net.lpcamors.optical.CORecipeTypes;
import net.lpcamors.optical.blocks.IBeamReceiver;
import net.lpcamors.optical.blocks.optical_source.BeamHelper;
import net.lpcamors.optical.recipes.FocusingRecipe;
import net.lpcamors.optical.recipes.FocusingRecipeParams;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class BeamFocuserHelper {
    public static Optional<FocusingRecipe> canBeProcessed(Level world, RecipeWrapper w, BeamHelper.BeamType beamType) {
        FocusingRecipeParams.BeamTypeConditionProfile.initializeRecipes(world);
        Optional<FocusingRecipe> focusingRecipe = SequencedAssemblyRecipe.getRecipe((Level)world, (ItemStack)w.m_8020_(0), CORecipeTypes.FOCUSING.getType(), FocusingRecipe.class);
        if (focusingRecipe.isEmpty()) {
            focusingRecipe = world.m_7465_().m_44015_(CORecipeTypes.FOCUSING.getType(), (Container)w, world);
        }
        if (focusingRecipe.isEmpty()) {
            focusingRecipe = FocusingRecipeParams.BeamTypeConditionProfile.getRecipeFor(world, w, beamType);
        }
        if (focusingRecipe.isPresent() && focusingRecipe.get().beamTypeCondition.test(beamType)) {
            return focusingRecipe;
        }
        return Optional.empty();
    }

    public static Optional<FocusingRecipe> hasRequired(Level world, RecipeWrapper w, BeamHelper.BeamType beamType, FilteringBehaviour b) {
        Optional focusingRecipe = SequencedAssemblyRecipe.getRecipe((Level)world, (ItemStack)w.m_8020_(0), CORecipeTypes.FOCUSING.getType(), FocusingRecipe.class);
        if (focusingRecipe.isEmpty()) {
            focusingRecipe = world.m_7465_().m_44015_(CORecipeTypes.FOCUSING.getType(), (Container)w, world);
        }
        if (focusingRecipe.isEmpty()) {
            FocusingRecipeParams.BeamTypeConditionProfile.getRecipeFor(world, w, beamType);
        }
        return focusingRecipe;
    }

    public static ItemStack getResult(Level world, ItemStack stack, IBeamReceiver.BeamSourceInstance beamSourceInstance) {
        Optional<FocusingRecipe> op;
        RecipeWrapper w = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
        w.m_6836_(0, stack);
        FocusingRecipe focusingRecipe = SequencedAssemblyRecipe.getRecipe((Level)world, (ItemStack)stack, CORecipeTypes.FOCUSING.getType(), FocusingRecipe.class).filter(BeamFocuserHelper::test).orElseGet(() -> {
            for (Recipe recipe : world.m_7465_().m_44056_(CORecipeTypes.FOCUSING.getType(), (Container)w, world)) {
                FocusingRecipe fr = (FocusingRecipe)recipe;
                if (!BeamFocuserHelper.test(fr)) continue;
                return fr;
            }
            return null;
        });
        if (focusingRecipe == null && (op = FocusingRecipeParams.BeamTypeConditionProfile.getRecipeFor(world, w, beamSourceInstance.optionalBeamProperties().get().beamType)).isPresent()) {
            focusingRecipe = op.get();
        }
        if (focusingRecipe != null) {
            List results = focusingRecipe.rollResults();
            stack.m_41774_(1);
            return results.isEmpty() ? ItemStack.f_41583_ : (ItemStack)results.get(0);
        }
        return ItemStack.f_41583_;
    }

    public static boolean test(FocusingRecipe focusingRecipe) {
        return true;
    }
}

