/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.render.RenderTypes;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.lpcamors.optical.COPartialModels;
import net.lpcamors.optical.COUtils;
import net.lpcamors.optical.blocks.IBeamReceiver;
import net.lpcamors.optical.blocks.absorption_polarizing_filter.AbsorptionPolarizingFilter;
import net.lpcamors.optical.blocks.optical_source.BeamHelper;
import net.lpcamors.optical.data.COTags;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public interface IBeamSource {
    public BeamHelper.BeamProperties getInitialBeamProperties();

    public void addToBeamBlocks(Vec3i var1, Vec3i var2, BeamHelper.BeamProperties var3);

    public BlockPos m_58899_();

    public Level m_58904_();

    public Map<Pair<Vec3i, Vec3i>, BeamHelper.BeamProperties> getBeamPropertiesMap();

    public boolean isDependent(BlockPos var1);

    public void addDependent(BlockPos var1);

    public int getTickCount();

    public boolean shouldRendererLaserBeam();

    public static void propagateLinearBeamVar(IBeamSource iBeamSource, BlockPos initialPos, BeamHelper.BeamProperties beamProperties, int lastIndex) {
        if (iBeamSource.getInitialBeamProperties() == null) {
            return;
        }
        BlockPos lastPos = initialPos;
        Direction direction = beamProperties.direction;
        BeamHelper.BeamType beamType = iBeamSource.getInitialBeamProperties().getType();
        int range = beamType.getRange();
        int i = 0;
        while (i + lastIndex <= range) {
            Block block;
            BlockPos vec3 = lastPos = lastPos.m_121945_(direction);
            BlockState state = iBeamSource.m_58904_().m_8055_(lastPos);
            boolean penetrable = state.m_204336_(COTags.Blocks.PENETRABLE) && !state.m_204336_(COTags.Blocks.IMPENETRABLE);
            LivingEntity livingEntity = IBeamReceiver.getNearLivingEntity(iBeamSource.m_58904_(), lastPos, 3.0, direction).orElse(null);
            if (livingEntity != null && (penetrable || state.m_60734_() instanceof IBeamReceiver)) {
                beamType.livingEntityBiConsumer.accept(livingEntity, beamProperties);
                if (!iBeamSource.getInitialBeamProperties().canPassThroughEntities()) {
                    iBeamSource.addToBeamBlocks((Vec3i)initialPos, (Vec3i)vec3, beamProperties);
                    break;
                }
            }
            if ((block = state.m_60734_()) instanceof IBeamReceiver) {
                IBeamReceiver iBeamReceiver = (IBeamReceiver)block;
                iBeamSource.addToBeamBlocks((Vec3i)initialPos, (Vec3i)vec3, beamProperties);
                iBeamReceiver.receive(iBeamSource, state, lastPos, beamProperties, i + 1);
                iBeamSource.m_58904_().m_7260_(lastPos, state, state, 16);
                break;
            }
            block = state.m_60734_();
            if (block instanceof BeaconBeamBlock) {
                BeaconBeamBlock beaconBeamBlock = (BeaconBeamBlock)block;
                iBeamSource.addToBeamBlocks((Vec3i)initialPos, (Vec3i)vec3, beamProperties);
                BeamHelper.BeamProperties beamProperties1 = new BeamHelper.BeamProperties(beamProperties.intensity, beamProperties.beamPolarization, BeamHelper.colorSum(beamProperties.color, COUtils.getColor(beaconBeamBlock.m_7988_())), direction, beamProperties.spin, beamProperties.beamType);
                IBeamSource.propagateLinearBeamVar(iBeamSource, lastPos, beamProperties1, i + 1);
                break;
            }
            if (i + lastIndex >= range || !penetrable) {
                iBeamSource.addToBeamBlocks((Vec3i)initialPos, (Vec3i)vec3, beamProperties);
                beamType.blockStateBiConsumer.accept(iBeamSource.m_58904_().m_8055_(lastPos), beamProperties);
                break;
            }
            ++i;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ClientSide {
        public static final ResourceLocation LASER_BEAM_LOCATION = new ResourceLocation("create_optical", "textures/block/optical_source/optical_source_laser_beam.png");
        static final RenderType LASER_BEAM_RENDER_TYPE = RenderType.m_234335_((ResourceLocation)LASER_BEAM_LOCATION, (boolean)true);

        @Deprecated
        public static void renderLaserBeam(IBeamSource iBeamSource, float partialTicks, PoseStack ms, MultiBufferSource multiBufferSource, int light) {
            Vec3 pos = iBeamSource.m_58899_().m_252807_();
            List blockPosToBeam = iBeamSource.getBeamPropertiesMap().keySet().stream().toList();
            for (int i = 0; i < blockPosToBeam.size(); ++i) {
                Pair pair = (Pair)blockPosToBeam.get(i);
                BeamHelper.BeamProperties beamProperties = iBeamSource.getBeamPropertiesMap().get(pair);
                Vec3i rgb = beamProperties.color;
                int alpha = (int)(beamProperties.intensity * 255.0f);
                Vec3 vec = Vec3.m_82512_((Vec3i)((Vec3i)pair.getFirst()));
                Vec3 vec1 = Vec3.m_82512_((Vec3i)((Vec3i)pair.getSecond()));
                Vec3 v = IBeamReceiver.getLaserIrradiatedFaceOffset(beamProperties.direction, new BlockPos((Vec3i)pair.getFirst()), iBeamSource.m_58904_());
                Vec3 v1 = IBeamReceiver.getLaserIrradiatedFaceOffset(beamProperties.direction, new BlockPos((Vec3i)pair.getSecond()), iBeamSource.m_58904_());
                vec = vec.m_82549_(v);
                vec1 = vec1.m_82549_(v1);
                double x = vec1.m_7096_() - vec.m_7096_();
                double y = vec1.m_7098_() - vec.m_7098_();
                double z = vec1.m_7094_() - vec.m_7094_();
                float f = Mth.m_14116_((float)((float)(x * x + z * z)));
                float f1 = Mth.m_14116_((float)((float)(x * x + y * y + z * z)));
                ms.m_85836_();
                ms.m_252880_(0.5f, 0.5f, 0.5f);
                ms.m_85837_(vec.f_82479_ - pos.f_82479_, vec.f_82480_ - pos.f_82480_, vec.f_82481_ - pos.f_82481_);
                ms.m_252781_(Axis.f_252436_.m_252961_((float)(-Math.atan2(z, x) + 1.5707963267948966)));
                ms.m_252781_(Axis.f_252529_.m_252961_((float)(Math.atan2(f, y) - 1.5707963267948966)));
                VertexConsumer vertexconsumer = multiBufferSource.m_6299_(RenderTypes.itemGlowingTranslucent());
                int intensityMultiplier = 1 + (int)Math.floor(beamProperties.intensity / 16.0f);
                float t = (partialTicks + (float)iBeamSource.getTickCount()) * (float)intensityMultiplier;
                float f2 = 0.0f - t * 0.01f;
                float f3 = Mth.m_14116_((float)((float)(x * x + y * y + z * z))) / 32.0f - t * 0.01f;
                float radius = 0.05f;
                float f4 = 0.0f;
                float f5 = radius;
                float f6 = 0.0f;
                PoseStack.Pose posestack$pose = ms.m_85850_();
                Matrix4f matrix4f = posestack$pose.m_252922_();
                Matrix3f matrix3f = posestack$pose.m_252943_();
                for (int k = 0; k < 3 + intensityMultiplier; ++k) {
                    if (k > 0) {
                        radius *= 1.2f;
                        vertexconsumer = multiBufferSource.m_6299_(RenderTypes.entityTranslucentBlockMipped());
                        alpha = (int)((float)alpha * 0.75f);
                    }
                    for (int j = 1; j <= 8; ++j) {
                        float f7 = Mth.m_14031_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * radius;
                        float f8 = Mth.m_14089_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * radius;
                        float f9 = (float)j / 8.0f;
                        vertexconsumer.m_252986_(matrix4f, f4, f5, 0.0f).m_6122_(rgb.m_123341_(), rgb.m_123342_(), rgb.m_123343_(), alpha).m_7421_(f6, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                        vertexconsumer.m_252986_(matrix4f, f4, f5, f1).m_6122_(rgb.m_123341_(), rgb.m_123342_(), rgb.m_123343_(), alpha).m_7421_(f6, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                        vertexconsumer.m_252986_(matrix4f, f7, f8, f1).m_6122_(rgb.m_123341_(), rgb.m_123342_(), rgb.m_123343_(), alpha).m_7421_(f9, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                        vertexconsumer.m_252986_(matrix4f, f7, f8, 0.0f).m_6122_(rgb.m_123341_(), rgb.m_123342_(), rgb.m_123343_(), alpha).m_7421_(f9, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                        f4 = f7;
                        f5 = f8;
                        f6 = f9;
                    }
                }
                ms.m_85849_();
            }
        }

        public static void renderLaserBeam(IBeamSource be, BlockState state, PoseStack ms, MultiBufferSource buffer) {
            Vec3 pos = be.m_58899_().m_252807_();
            List blockPosToBeam = be.getBeamPropertiesMap().keySet().stream().toList();
            Direction direction = (Direction)state.m_61143_((Property)AbsorptionPolarizingFilter.f_54117_);
            for (int i = 0; i < blockPosToBeam.size(); ++i) {
                Pair pair = (Pair)blockPosToBeam.get(i);
                BeamHelper.BeamProperties beamProperties = be.getBeamPropertiesMap().get(pair);
                direction = beamProperties.direction;
                Vec3 start0 = Vec3.m_82512_((Vec3i)((Vec3i)pair.getFirst()));
                Vec3 end0 = Vec3.m_82512_((Vec3i)((Vec3i)pair.getSecond()));
                Vec3 start = start0.m_82546_(IBeamReceiver.getLaserIrradiatedFaceOffsetVar(beamProperties.direction, new BlockPos((Vec3i)pair.getFirst()), be.m_58904_()));
                Vec3 end = end0.m_82549_(IBeamReceiver.getLaserIrradiatedFaceOffsetVar(beamProperties.direction, new BlockPos((Vec3i)pair.getSecond()), be.m_58904_()));
                ms.m_85836_();
                ClientSide.translateForVec(ms, start0.m_82546_(pos));
                ClientSide.translateForVec(ms, start.m_82546_(start0));
                ClientSide.translateForVec(ms, end.m_82546_(start).m_82542_(0.5, 0.5, 0.5));
                float f = (float)end.m_82546_(start).m_82553_();
                float f1 = (float)end.m_82546_(start).m_82553_();
                SuperByteBuffer laser = CachedBuffers.partial((PartialModel)COPartialModels.LASER_BEAM, (BlockState)state).light(0xF000F0).disableDiffuse();
                Vec3 dir = direction.m_122421_() == Direction.AxisDirection.POSITIVE ? Vec3.m_82528_((Vec3i)direction.m_122436_()) : Vec3.m_82528_((Vec3i)direction.m_122436_()).m_82490_(-1.0);
                Vec3 nDir = new Vec3(1.0, 1.0, 1.0).m_82546_(dir);
                Vec3i color = beamProperties.color;
                int jMax = 3 + (int)Math.floor(beamProperties.intensity / 32.0f);
                int jRest = Math.max(0, jMax - 10);
                jMax = Math.min(10, jMax);
                for (int j = 0; j < jMax; ++j) {
                    SuperByteBuffer laser0 = laser;
                    double radius = 0.8 + (double)(j + jRest) * 0.2;
                    int alpha = (int)(255.0f * (1.0f - (float)j / 10.0f));
                    laser0.color(color.m_123341_(), color.m_123342_(), color.m_123343_(), alpha);
                    ClientSide.scaleForVec(laser0, dir.m_82490_((double)f).m_82549_(nDir));
                    ClientSide.scaleForVec(laser0, nDir.m_82490_(radius).m_82549_(dir));
                    ClientSide.rotateDirection(laser0, direction);
                    laser0.renderInto(ms, j == 0 ? buffer.m_6299_(RenderTypes.additive()) : buffer.m_6299_(RenderType.m_110472_()));
                }
                ms.m_85849_();
            }
        }

        static void translateForVec(PoseStack ms, Vec3 vec3) {
            ms.m_85837_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        }

        static void scaleForVec(SuperByteBuffer s, Vec3 vec3) {
            ((SuperByteBuffer)((SuperByteBuffer)s.center()).scale((float)vec3.f_82479_, (float)vec3.f_82480_, (float)vec3.f_82481_)).uncenter();
        }

        static void rotateDirection(SuperByteBuffer buffer, Direction direction) {
            float yRot = (float)((double)AngleHelper.horizontalAngle((Direction)direction) * Math.PI / 180.0);
            float xRot = (float)direction.m_122430_() * (float)Math.PI / 2.0f;
            buffer.rotateCentered(yRot, Direction.UP);
            buffer.rotateCentered(xRot, Direction.EAST);
        }
    }
}

