/*
 * Decompiled with CFR 0.152.
 */
package elocindev.item_obliterator.forge.mixin;

import elocindev.item_obliterator.forge.utils.Utils;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerPlayer.class}, priority=10000)
public class ServerPlayerMixin {
    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getItem()Lnet/minecraft/world/item/Item;")}, method={"doTick"}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void playerTick(CallbackInfo info, int i) {
        ItemStack item = ((ServerPlayer)this).m_150109_().m_8020_(i);
        if (Utils.isDisabled(item)) {
            item.m_41764_(0);
            ((ServerPlayer)this).m_240418_((Component)Component.m_237113_((String)"This item is disabled."), true);
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCancelItemUse(Entity target, CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        Item item = player.m_21205_().m_41720_();
        String itemid = Utils.getItemId(item);
        if (Utils.isDisabledAttack(itemid)) {
            player.m_240418_((Component)Component.m_237113_((String)"This item's attacks are disabled."), true);
            ci.cancel();
        }
    }

    @Inject(method={"swing"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelSwing(InteractionHand hand, CallbackInfo ci) {
        Player player = (Player)this;
        Item item = player.m_21205_().m_41720_();
        String itemid = Utils.getItemId(item);
        if (Utils.isDisabledAttack(itemid)) {
            ci.cancel();
        }
    }
}

