/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.containers;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.SlotItemHandler;

public abstract class AbstractPipeGui<T extends AbstractPipeContainer<?>>
extends AbstractContainerScreen<T> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("prettypipes", "textures/gui/pipe.png");
    private final List<Tab> tabs = new ArrayList<Tab>();
    private final ItemStack[] lastItems;

    public AbstractPipeGui(T screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.lastItems = new ItemStack[((AbstractPipeContainer)this.f_97732_).tile.modules.getSlots()];
        this.f_97726_ = 176;
        this.f_97727_ = 203;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initTabs();
    }

    public void m_181908_() {
        super.m_181908_();
        boolean changed = false;
        for (int i = 0; i < ((AbstractPipeContainer)this.f_97732_).tile.modules.getSlots(); ++i) {
            ItemStack stack = ((AbstractPipeContainer)this.f_97732_).tile.modules.getStackInSlot(i);
            if (stack == this.lastItems[i]) continue;
            this.lastItems[i] = stack;
            changed = true;
        }
        if (changed) {
            this.initTabs();
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        for (Renderable renderable : this.f_169369_) {
        }
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280056_(this.f_96547_, this.f_169604_.getString(), 8, this.f_97727_ - 96 + 2, 0x404040, false);
        graphics.m_280056_(this.f_96547_, this.f_96539_.getString(), 8, 38, 0x404040, false);
        for (Tab tab : this.tabs) {
            tab.drawForeground(graphics, mouseX, mouseY);
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_ + 32, 0, 0, 176, 171);
        for (Tab tab : this.tabs) {
            tab.draw(graphics);
        }
        for (Slot slot : ((AbstractPipeContainer)this.f_97732_).f_38839_) {
            if (!(slot instanceof SlotItemHandler)) continue;
            graphics.m_280218_(TEXTURE, this.f_97735_ + slot.f_40220_ - 1, this.f_97736_ + slot.f_40221_ - 1, 176, 62, 18, 18);
        }
    }

    public boolean m_6375_(double x, double y, int button) {
        for (Tab tab : this.tabs) {
            if (!tab.onClicked(x, y, button)) continue;
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    private void initTabs() {
        this.tabs.clear();
        this.tabs.add(new Tab(new ItemStack((ItemLike)Registry.pipeBlock), 0, -1));
        for (int i = 0; i < ((AbstractPipeContainer)this.f_97732_).tile.modules.getSlots(); ++i) {
            IModule module;
            ItemStack stack = ((AbstractPipeContainer)this.f_97732_).tile.modules.getStackInSlot(i);
            if (stack.m_41619_() || !(module = (IModule)stack.m_41720_()).hasContainer(stack, ((AbstractPipeContainer)this.f_97732_).tile)) continue;
            this.tabs.add(new Tab(stack, this.tabs.size(), i));
        }
    }

    private class Tab {
        private final ItemStack moduleStack;
        private final int index;
        private final int x;
        private final int y;

        public Tab(ItemStack moduleStack, int tabIndex, int index) {
            this.moduleStack = moduleStack;
            this.index = index;
            this.x = AbstractPipeGui.this.f_97735_ + 5 + tabIndex * 28;
            this.y = AbstractPipeGui.this.f_97736_;
        }

        private void draw(GuiGraphics graphics) {
            int y = 2;
            int v = 0;
            int height = 30;
            int itemOffset = 9;
            if (this.index == ((AbstractPipeContainer)((AbstractPipeGui)AbstractPipeGui.this).f_97732_).moduleIndex) {
                y = 0;
                v = 30;
                height = 32;
                itemOffset = 7;
            }
            graphics.m_280218_(TEXTURE, this.x, this.y + y, 176, v, 28, height);
            graphics.m_280480_(this.moduleStack, this.x + 6, this.y + itemOffset);
        }

        private void drawForeground(GuiGraphics graphics, int mouseX, int mouseY) {
            if (mouseX < this.x || mouseY < this.y || mouseX >= this.x + 28 || mouseY >= this.y + 32) {
                return;
            }
            graphics.m_280557_(AbstractPipeGui.this.f_96547_, this.moduleStack.m_41786_(), mouseX - AbstractPipeGui.this.f_97735_, mouseY - AbstractPipeGui.this.f_97736_);
        }

        private boolean onClicked(double mouseX, double mouseY, int button) {
            if (this.index == ((AbstractPipeContainer)((AbstractPipeGui)AbstractPipeGui.this).f_97732_).moduleIndex) {
                return false;
            }
            if (button != 0) {
                return false;
            }
            if (mouseX < (double)this.x || mouseY < (double)this.y || mouseX >= (double)(this.x + 28) || mouseY >= (double)(this.y + 32)) {
                return false;
            }
            PacketHandler.sendToServer(new PacketButton(((AbstractPipeContainer)((AbstractPipeGui)AbstractPipeGui.this).f_97732_).tile.m_58899_(), PacketButton.ButtonResult.PIPE_TAB, this.index));
            AbstractPipeGui.this.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
    }
}

