/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.mehvahdjukaar.every_compat.ECNetworking;
import net.mehvahdjukaar.every_compat.ECRegistry;
import net.mehvahdjukaar.every_compat.api.AbstractSimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.configs.ECConfigs;
import net.mehvahdjukaar.every_compat.configs.ModEntriesConfigs;
import net.mehvahdjukaar.every_compat.configs.UnsafeDisablerConfigs;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EveryCompat {
    public static final String MOD_ID = "everycomp";
    public static final Logger LOGGER = LogManager.getLogger((String)"Every Compat");
    private static final Multimap<String, CompatModule> ACTIVE_MODULES = MultimapBuilder.linkedHashKeys().arrayListValues().build();
    private static final List<CompatMod> COMPAT_MODS = new ArrayList<CompatMod>();
    private static final Set<String> DEPENDENCIES = new HashSet<String>();
    private static final Set<String> ADDON_IDS = new HashSet<String>();
    private static final Map<Class<? extends BlockType>, Set<String>> TYPES_TO_CHILD_KEYS = new Object2ObjectOpenHashMap();
    private static final Map<Object, CompatModule> ITEMS_TO_MODULES = new Object2ObjectOpenHashMap();
    private static final Set<Class<? extends BlockType>> AFFECTED_TYPES = new HashSet<Class<? extends BlockType>>();
    static boolean canShowErrorScreen = PlatHelper.getPhysicalSide().isClient();
    private static final Set<CompatModule> ERRORED = new HashSet<CompatModule>();
    private static int prevRegSize = 0;

    public static ResourceLocation res(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static void forAllModules(Consumer<CompatModule> action) {
        for (CompatModule m : ACTIVE_MODULES.values()) {
            try {
                action.accept(m);
            }
            catch (Throwable e) {
                LOGGER.error("Module for mod {} contains errors. This could mean that the mod has been recently updated and Every Compat needs updating (try downgrading the mod) or that you are using an older version.", (Object)m.getModName(), (Object)e);
                if (canShowErrorScreen) {
                    ERRORED.add(m);
                    continue;
                }
                throw e;
            }
        }
    }

    public static CompatModule getModuleOfItem(Item item) {
        return ITEMS_TO_MODULES.get(item);
    }

    public static <T extends BlockType> void trackChildType(Class<T> type, String childId) {
        TYPES_TO_CHILD_KEYS.computeIfAbsent(type, t -> new HashSet()).add(childId);
    }

    public static Collection<String> getChildKeys(Class<? extends BlockType> type) {
        return TYPES_TO_CHILD_KEYS.getOrDefault(type, Set.of());
    }

    public static void addOtherCompatMod(String compatModId, String fromModId, String supportedModId) {
        EveryCompat.addOtherCompatMod(compatModId, List.of(fromModId), List.of(supportedModId));
    }

    public static void addOtherCompatMod(String compatModId, String fromModId, String ... supportedModId) {
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, supportedModId);
        EveryCompat.addOtherCompatMod(compatModId, List.of(fromModId), list);
    }

    public static void addOtherCompatMod(String compatModId, List<String> fromModId, String ... supportedModId) {
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, supportedModId);
        EveryCompat.addOtherCompatMod(compatModId, fromModId, list);
    }

    public static void addOtherCompatMod(String compatModId, List<String> fromModId, String supportedModId) {
        EveryCompat.addOtherCompatMod(compatModId, fromModId, List.of(supportedModId));
    }

    public static synchronized void addOtherCompatMod(String compatModId, List<String> fromModId, List<String> supportedModId) {
        COMPAT_MODS.add(new CompatMod(compatModId, fromModId, supportedModId));
        DEPENDENCIES.add(compatModId);
        DEPENDENCIES.addAll(fromModId);
        DEPENDENCIES.addAll(supportedModId);
    }

    public static synchronized void addModule(CompatModule module) {
        if (!UnsafeDisablerConfigs.modulesList.get().contains(module.getModId())) {
            ACTIVE_MODULES.put((Object)module.getModId(), (Object)module);
            DEPENDENCIES.add(module.getModId());
            DEPENDENCIES.addAll(module.getAlreadySupportedMods());
            ((DynamicDataPack)ServerDynamicResourcesHandler.INSTANCE.getPack()).addNamespaces(module.getServerResourcesNamespaces());
            if (PlatHelper.getPhysicalSide().isClient()) {
                ((DynamicTexturePack)ClientDynamicResourcesHandler.getInstance().getPack()).addNamespaces(module.getClientResourcesNamespaces());
            }
            for (Class<? extends BlockType> t : module.getAffectedTypes()) {
                EveryCompat.addDynamicRegistrationFor(t);
            }
            ADDON_IDS.add(module.getMyNamespace());
        }
    }

    public static void addIfLoaded(String modId, Supplier<Function<String, CompatModule>> moduleFactory) {
        if (PlatHelper.isModLoaded((String)modId)) {
            CompatModule module = moduleFactory.get().apply(modId);
            EveryCompat.addModule(module);
        }
    }

    @SafeVarargs
    public static void addMultipleIfLoaded(String modId, Supplier<Function<String, CompatModule>> ... moduleFactories) {
        for (Supplier<Function<String, CompatModule>> moduleFactory : moduleFactories) {
            EveryCompat.addIfLoaded(modId, moduleFactory);
        }
    }

    public static Collection<CompatMod> getCompatMods() {
        return COMPAT_MODS;
    }

    public static Collection<String> getDependencies() {
        return DEPENDENCIES;
    }

    public static void init() {
        ECConfigs.init();
        UnsafeDisablerConfigs.init();
        ECNetworking.init();
        ECRegistry.init();
        ServerDynamicResourcesHandler.INSTANCE.register();
        RegHelper.addItemsToTabsRegistration(EveryCompat::registerItemsToTabs);
        PlatHelper.addCommonSetup(EveryCompat::setup);
        BlockSetAPI.addDynamicRegistration((r, c) -> EveryCompat.registerItems((Registrator<Item>)r), WoodType.class, (Registry)BuiltInRegistries.f_257033_);
        BlockSetAPI.addDynamicRegistration((r, c) -> EveryCompat.registerTiles(r), WoodType.class, (Registry)BuiltInRegistries.f_257049_);
        BlockSetAPI.addDynamicRegistration((r, c) -> EveryCompat.registerEntities(r), WoodType.class, (Registry)BuiltInRegistries.f_256780_);
    }

    public static void setup() {
        String activeModulesString = ACTIVE_MODULES.keySet().stream().map(key -> {
            int count = ACTIVE_MODULES.get(key).size();
            return count > 1 ? key + "(" + count + ")" : key;
        }).collect(Collectors.joining(", ", "[", "]"));
        LOGGER.info("Every Compat has loaded {} modules: {}", (Object)ACTIVE_MODULES.size(), (Object)activeModulesString);
        if (PlatHelper.isModLoaded((String)"chipped")) {
            LOGGER.warn("Chipped is installed. The mod on its own adds a ludicrous amount of blocks. With Every Compat this can easily explode. You have been warned");
        }
        int newSize = BuiltInRegistries.f_256975_.m_13562_();
        int myChildrenSize = AbstractSimpleEntrySet.totalChildren;
        float p = (float)myChildrenSize / (float)newSize * 100.0f;
        if (myChildrenSize == 0) {
            String log = "\n###########################################################################################################\n#                                                                                                         #\n# ATTENTION: EVERY COMPAT REGISTERED 0 BLOCK! No Wood mods (Biomes O' Plenty or others) are installed. #\n#                           You dont need EveryCompat and should remove it.                               #\n#                                                                                                         #\n###########################################################################################################\n";
            LOGGER.error("\n{}", (Object)log);
            return;
        }
        if (p > 25.0f) {
            LOGGER.warn("Registered {} compat blocks making up {}% of total blocks registered", (Object)myChildrenSize, (Object)String.format("%.2f", Float.valueOf(p)));
        } else {
            LOGGER.info("Registered {} compat blocks making up {}% of total blocks registered", (Object)myChildrenSize, (Object)String.format("%.2f", Float.valueOf(p)));
        }
        if (p > 33.0f) {
            Optional<CompatModule> compatbloated = ACTIVE_MODULES.values().stream().max(Comparator.comparing(CompatModule::bloatAmount));
            if (compatbloated.isPresent()) {
                CompatModule bloated = compatbloated.get();
                LOGGER.info("Registered {} compat blocks making up {}% of total blocks registered", (Object)myChildrenSize, (Object)String.format("%.2f", Float.valueOf(p)));
                LOGGER.error("Every Compat registered blocks make up more than one third of your registered blocks, taking up memory and load time.");
                LOGGER.error("You might want to uninstall some mods, biggest offender was {} ({} blocks)", (Object)bloated.getModName().toUpperCase(Locale.ROOT), (Object)bloated.bloatAmount());
            } else {
                String log = "\n#######################################################\n#                                                     #\n#     ATTENTION: No supported mods are installed.     #\n#   You dont need EveryCompat and should remove it.   #\n#                                                     #\n#######################################################\n";
                LOGGER.error("\n{}", (Object)log);
            }
        }
        EveryCompat.forAllModules(CompatModule::onModSetup);
        canShowErrorScreen = true;
    }

    public static <T extends BlockType> void addDynamicRegistrationFor(Class<T> t) {
        if (AFFECTED_TYPES.add(t)) {
            BlockSetAPI.addDynamicBlockRegistration((r, c) -> {
                if (prevRegSize == 0) {
                    prevRegSize = BuiltInRegistries.f_256975_.m_13562_();
                }
                LOGGER.info("Registering Compat {} Blocks", (Object)t.getSimpleName());
                EveryCompat.forAllModules(m -> m.registerBlocks(t, (Registrator<Block>)r, c));
            }, t);
            BlockSetAPI.addDynamicItemRegistration((r, c) -> ModEntriesConfigs.initEarlyButNotSuperEarly(), t);
        }
    }

    protected static void registerItems(Registrator<Item> event) {
        EveryCompat.forAllModules(m -> m.registerItems((Registrator<Item>)((Registrator)(id, o) -> {
            event.register(id, o);
            ITEMS_TO_MODULES.put(o, (CompatModule)m);
        })));
    }

    protected static void registerTiles(Registrator<BlockEntityType<?>> event) {
        EveryCompat.forAllModules(m -> m.registerTiles(event));
    }

    protected static void registerEntities(Registrator<EntityType<?>> event) {
        EveryCompat.forAllModules(m -> m.registerEntities(event));
    }

    public static boolean isMyIdOrAddon(String namespace) {
        return ADDON_IDS.contains(namespace);
    }

    public static Collection<CompatModule> getModulesOfMod(String modId) {
        return ACTIVE_MODULES.get((Object)modId);
    }

    private static void registerItemsToTabs(RegHelper.ItemToTabEvent event) {
        if (ECConfigs.TAB_ENABLED.get().booleanValue()) {
            LinkedHashMap typeToEntrySet = new LinkedHashMap();
            for (BlockTypeRegistry blockTypeRegistry : BlockSetAPI.getRegistries()) {
                for (BlockType type : blockTypeRegistry.getValues()) {
                    EveryCompat.forAllModules(m -> typeToEntrySet.computeIfAbsent(m.getDedicatedTab(), j -> new LinkedHashMap()).computeIfAbsent(type, j -> new ArrayList()).addAll(m.getAllItemsOfType(type)));
                }
            }
            for (Map.Entry entry : typeToEntrySet.entrySet()) {
                for (List ee : ((Map)entry.getValue()).values()) {
                    event.add((ResourceKey)entry.getKey(), (ItemLike[])ee.toArray(ItemLike[]::new));
                }
            }
        } else {
            EveryCompat.forAllModules(m -> m.registerItemsToExistingTabs(event));
        }
    }

    public static List<String> getModulesThatErrored() {
        return ERRORED.stream().map(CompatModule::getModName).toList();
    }

    public record CompatMod(String modId, List<String> woodsFrom, List<String> blocksFrom) {
    }
}

