/*
 * Decompiled with CFR 0.152.
 */
package me.drex.crashexploitfixer.mixin;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TagParser.class})
public abstract class TagParserMixin {
    @Shadow
    @Final
    private StringReader f_129347_;
    @Unique
    private static final SimpleCommandExceptionType ERROR_COMPLEX_NBT = new SimpleCommandExceptionType((Message)new LiteralMessage("NBT tag is too complex, depth > 512"));
    @Unique
    private int crashexploitfixer$depth;

    @Inject(method={"readStruct"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/TagParser;expect(C)V", ordinal=0, shift=At.Shift.AFTER)})
    private void increaseDepthStruct(CallbackInfoReturnable<CompoundTag> cir) throws CommandSyntaxException {
        this.increaseDepth();
    }

    @Inject(method={"readStruct"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/TagParser;expect(C)V", ordinal=2, shift=At.Shift.AFTER)})
    private void decreaseDepthStruct(CallbackInfoReturnable<CompoundTag> cir) {
        --this.crashexploitfixer$depth;
    }

    @Inject(method={"readListTag"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/TagParser;expect(C)V", ordinal=0, shift=At.Shift.AFTER)})
    private void increaseDepthList(CallbackInfoReturnable<CompoundTag> cir) throws CommandSyntaxException {
        this.increaseDepth();
    }

    @Inject(method={"readListTag"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/TagParser;expect(C)V", ordinal=1, shift=At.Shift.AFTER)})
    private void decreaseDepthList(CallbackInfoReturnable<CompoundTag> cir) {
        --this.crashexploitfixer$depth;
    }

    private void increaseDepth() throws CommandSyntaxException {
        ++this.crashexploitfixer$depth;
        if (this.crashexploitfixer$depth > 512) {
            throw ERROR_COMPLEX_NBT.createWithContext((ImmutableStringReader)this.f_129347_);
        }
    }
}

