/*
 * Decompiled with CFR 0.152.
 */
package com.biomemusic.config;

import com.biomemusic.BiomeMusic;
import com.biomemusic.environment.MusicEnvironment;
import com.biomemusic.environment.MusicType;
import com.cupboard.config.ICommonConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CommonConfiguration
implements ICommonConfig {
    public double delayModifier = 0.35;
    public float pitchVariance = 0.0f;
    public boolean musicVariance = true;
    public boolean displayMusicPlayed = false;
    public boolean logloadedmusic = false;
    public boolean smartMusic = true;
    public int maxConcurrentSounds = 10;
    public Map<MusicType, MusicType.MusicTypeData> musicConditions = new LinkedHashMap<MusicType, MusicType.MusicTypeData>();

    public CommonConfiguration() {
        this.musicConditions.put(MusicType.Biome, new MusicType.MusicTypeData(MusicType.Biome, Set.of(), Set.of()));
        this.musicConditions.put(MusicType.Cave, new MusicType.MusicTypeData(MusicType.Cave, Set.of(MusicEnvironment.CAVE), Set.of(MusicEnvironment.WATER, MusicEnvironment.NETHER, MusicEnvironment.END)));
        this.musicConditions.put(MusicType.Night, new MusicType.MusicTypeData(MusicType.Night, Set.of(MusicEnvironment.NIGHT), Set.of(MusicEnvironment.NETHER, MusicEnvironment.END, MusicEnvironment.WATER, MusicEnvironment.CAVE)));
        this.musicConditions.put(MusicType.Water, new MusicType.MusicTypeData(MusicType.Water, Set.of(MusicEnvironment.WATER), Set.of(MusicEnvironment.NETHER, MusicEnvironment.END)));
        this.musicConditions.put(MusicType.Game, new MusicType.MusicTypeData(MusicType.Game, Set.of(), Set.of(MusicEnvironment.NETHER, MusicEnvironment.END, MusicEnvironment.WATER)));
        this.musicConditions.put(MusicType.End, new MusicType.MusicTypeData(MusicType.End, Set.of(MusicEnvironment.END), Set.of()));
        this.musicConditions.put(MusicType.Nether, new MusicType.MusicTypeData(MusicType.Nether, Set.of(MusicEnvironment.NETHER), Set.of()));
    }

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonObject entry = new JsonObject();
        entry.addProperty("desc:", "Modifies the delay between songs(requires a game restart), lower = shorter delay (1.0 = vanilla). Default = 0.25");
        entry.addProperty("delayModifier", (Number)this.delayModifier);
        root.add("delayModifier", (JsonElement)entry);
        JsonObject entry5 = new JsonObject();
        entry5.addProperty("desc:", "Adds randomized pitch variance of up to the given value (e.g. 0.1), makes songs sound slightly different. default = 0");
        entry5.addProperty("pitchVariance", (Number)Float.valueOf(this.pitchVariance));
        root.add("pitchVariance", (JsonElement)entry5);
        JsonObject entry2 = new JsonObject();
        entry2.addProperty("desc:", "Enables more varied music to be available for biomes chosen from similar other biomes, default = true");
        entry2.addProperty("musicVariance", Boolean.valueOf(this.musicVariance));
        root.add("musicVariance", (JsonElement)entry2);
        JsonObject entry6 = new JsonObject();
        entry6.addProperty("desc:", "Enables smart stopping of music, when the biome changes or player leaves a cave/water/night is over, default = true");
        entry6.addProperty("smartMusic", Boolean.valueOf(this.smartMusic));
        root.add("smartMusic", (JsonElement)entry6);
        JsonObject entry8 = new JsonObject();
        entry8.addProperty("desc:", "Sets the condition under which music from their respective categories is allowed to play. Required conditions need to be all met, a single matched disallowed conditions prevents it. Possible conditions are: " + Set.of(MusicEnvironment.values()));
        for (MusicType.MusicTypeData data : this.musicConditions.values()) {
            JsonObject musicCondition = new JsonObject();
            musicCondition.addProperty("requires", data.required.toString());
            musicCondition.addProperty("disallowed", data.disallowed.toString());
            entry8.add(data.type.name(), (JsonElement)musicCondition);
        }
        root.add("musicConditions", (JsonElement)entry8);
        JsonObject entry3 = new JsonObject();
        entry3.addProperty("desc:", "Shows currently played music in chat/log, default = false");
        entry3.addProperty("displayMusicPlayed", Boolean.valueOf(this.displayMusicPlayed));
        root.add("displayMusicPlayed", (JsonElement)entry3);
        JsonObject entry4 = new JsonObject();
        entry4.addProperty("desc:", "Prints the music files getting loaded into the latest.log, default = false");
        entry4.addProperty("logloadedmusic", Boolean.valueOf(this.logloadedmusic));
        root.add("logloadedmusic", (JsonElement)entry4);
        JsonObject entry10 = new JsonObject();
        entry10.addProperty("desc:", "Set the maximum amount of times the same sound can play at the same time. Limits the amount of lag spamming sounds can create. Default = 10");
        entry10.addProperty("maxConcurrentSounds", (Number)this.maxConcurrentSounds);
        root.add("maxConcurrentSounds", (JsonElement)entry10);
        return root;
    }

    public void deserialize(JsonObject data) {
        this.delayModifier = data.get("delayModifier").getAsJsonObject().get("delayModifier").getAsDouble();
        this.musicVariance = data.get("musicVariance").getAsJsonObject().get("musicVariance").getAsBoolean();
        this.displayMusicPlayed = data.get("displayMusicPlayed").getAsJsonObject().get("displayMusicPlayed").getAsBoolean();
        this.smartMusic = data.get("smartMusic").getAsJsonObject().get("smartMusic").getAsBoolean();
        this.logloadedmusic = data.get("logloadedmusic").getAsJsonObject().get("logloadedmusic").getAsBoolean();
        this.pitchVariance = data.get("pitchVariance").getAsJsonObject().get("pitchVariance").getAsFloat();
        this.maxConcurrentSounds = data.get("maxConcurrentSounds").getAsJsonObject().get("maxConcurrentSounds").getAsInt();
        JsonObject musicConditionData = data.get("musicConditions").getAsJsonObject();
        for (Map.Entry entry : musicConditionData.entrySet()) {
            MusicType type;
            if (((String)entry.getKey()).equals("desc:")) continue;
            try {
                type = MusicType.valueOf(((String)entry.getKey()).substring(0, 1).toUpperCase(Locale.ROOT) + ((String)entry.getKey()).substring(1).toLowerCase(Locale.ROOT));
            }
            catch (Exception e) {
                BiomeMusic.LOGGER.warn("Bad music type for music conditions: " + (String)entry.getKey() + " allowed music types are:" + Set.of(MusicType.values()));
                throw e;
            }
            JsonObject musicEntry = ((JsonElement)entry.getValue()).getAsJsonObject();
            String[] requiredEntries = musicEntry.get("requires").getAsString().replace("[", "").replace("]", "").replace(" ", "").split(",");
            HashSet<MusicEnvironment> required = new HashSet<MusicEnvironment>();
            for (String requiredEntry : requiredEntries) {
                MusicEnvironment condition;
                if (requiredEntry.isEmpty()) continue;
                try {
                    condition = MusicEnvironment.valueOf(requiredEntry.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    BiomeMusic.LOGGER.warn("Bad required music condition for music conditions: " + (String)entry.getKey() + " allowed condition values are:" + Set.of(MusicEnvironment.values()));
                    throw e;
                }
                required.add(condition);
            }
            String[] disallowedEntries = musicEntry.get("disallowed").getAsString().replace("[", "").replace("]", "").replace(" ", "").split(",");
            HashSet<MusicEnvironment> disallowed = new HashSet<MusicEnvironment>();
            for (String disallowedEntry : disallowedEntries) {
                MusicEnvironment condition;
                if (disallowedEntry.isEmpty()) continue;
                try {
                    condition = MusicEnvironment.valueOf(disallowedEntry.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    BiomeMusic.LOGGER.warn("Bad disallowed music condition for music conditions: " + (String)entry.getKey() + " allowed condition values are:" + Set.of(MusicEnvironment.values()));
                    throw e;
                }
                disallowed.add(condition);
            }
            this.musicConditions.put(type, new MusicType.MusicTypeData(type, required, disallowed));
        }
    }
}

