/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.extras.pages;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.embeddedt.embeddium.extras.ExtrasConfig;

public class EntityCullingPage
extends OptionPage {
    private static final SodiumOptionsStorage performanceOptionsStorage = new SodiumOptionsStorage();

    public EntityCullingPage() {
        super((Component)Component.m_237115_((String)"xenon.extras.options.culling.page"), EntityCullingPage.create());
    }

    private static ImmutableList<OptionGroup> create() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        OptionImpl<SodiumGameOptions, Boolean> enableDistanceChecks = OptionImpl.createBuilder(Boolean.TYPE, performanceOptionsStorage).setName((Component)Component.m_237115_((String)"xenon.extras.options.culling.entity.title")).setTooltip((Component)Component.m_237115_((String)"xenon.extras.options.culling.entity.desc")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            ExtrasConfig.entityDistanceCulling.set(value);
            ExtrasConfig.entityDistanceCullingCache = value;
        }, options -> ExtrasConfig.entityDistanceCullingCache).setImpact(OptionImpact.HIGH).build();
        OptionImpl<SodiumGameOptions, Integer> maxEntityDistance = OptionImpl.createBuilder(Integer.TYPE, performanceOptionsStorage).setName((Component)Component.m_237115_((String)"xenon.extras.options.culling.entity.distance.horizontal.title")).setTooltip((Component)Component.m_237115_((String)"xenon.extras.options.culling.entity.distance.horizontal.desc")).setControl(option -> new SliderControl((Option<Integer>)option, 16, 192, 8, ControlValueFormatter.biomeBlend())).setBinding((options, value) -> {
            int result = value * value;
            ExtrasConfig.entityCullingDistanceX.set((Object)result);
            ExtrasConfig.entityCullingDistanceXCache = result;
            ExtrasConfig.hostileDistanceXCache = (int)((float)(value * value) * ((float)((Integer)ExtrasConfig.hostileEntityModifier.get()).intValue() / 100.0f));
        }, options -> Math.toIntExact(Math.round(Math.sqrt(ExtrasConfig.entityCullingDistanceXCache)))).setImpact(OptionImpact.HIGH).build();
        OptionImpl<SodiumGameOptions, Integer> maxEntityDistanceVertical = OptionImpl.createBuilder(Integer.TYPE, performanceOptionsStorage).setName((Component)Component.m_237115_((String)"xenon.extras.options.culling.entity.distance.vertical.title")).setTooltip((Component)Component.m_237115_((String)"xenon.extras.options.culling.entity.distance.vertical.desc")).setControl(option -> new SliderControl((Option<Integer>)option, 16, 64, 4, ControlValueFormatter.biomeBlend())).setBinding((options, value) -> {
            ExtrasConfig.entityCullingDistanceY.set(value);
            ExtrasConfig.entityCullingDistanceYCache = value;
            ExtrasConfig.hostileDistanceYCache = (int)((float)value.intValue() * ((float)((Integer)ExtrasConfig.hostileEntityModifier.get()).intValue() / 100.0f));
        }, options -> ExtrasConfig.entityCullingDistanceYCache).setImpact(OptionImpact.HIGH).build();
        OptionImpl<SodiumGameOptions, Integer> hostileEntityModifier = OptionImpl.createBuilder(Integer.TYPE, performanceOptionsStorage).setName((Component)Component.m_237115_((String)"xenon.extras.options.culling.entity.distance.hostile.title")).setTooltip((Component)Component.m_237115_((String)"xenon.extras.options.culling.entity.distance.hostile.desc")).setControl(option -> new SliderControl((Option<Integer>)option, 25, 200, 5, ControlValueFormatter.percentage())).setBinding((options, value) -> {
            ExtrasConfig.hostileEntityModifier.set(value);
            float x = Mth.m_14116_((float)ExtrasConfig.entityCullingDistanceXCache) * ((float)value.intValue() / 100.0f);
            int y = ExtrasConfig.hostileDistanceYCache;
            ExtrasConfig.hostileDistanceXCache = (int)(x * x);
            ExtrasConfig.hostileDistanceYCache = (int)((float)y * ((float)value.intValue() / 100.0f));
        }, options -> (Integer)ExtrasConfig.hostileEntityModifier.get()).setImpact(OptionImpact.HIGH).build();
        groups.add(OptionGroup.createBuilder().add(enableDistanceChecks).add(maxEntityDistance).add(maxEntityDistanceVertical).add(hostileEntityModifier).build());
        OptionImpl<SodiumGameOptions, Boolean> enableTileDistanceChecks = OptionImpl.createBuilder(Boolean.TYPE, performanceOptionsStorage).setName((Component)Component.m_237115_((String)"xenon.extras.options.culling.tiles.title")).setTooltip((Component)Component.m_237115_((String)"xenon.extras.options.culling.tiles.desc")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            ExtrasConfig.tileEntityDistanceCulling.set(value);
            ExtrasConfig.tileEntityDistanceCullingCache = value;
        }, options -> ExtrasConfig.tileEntityDistanceCullingCache).setImpact(OptionImpact.HIGH).build();
        OptionImpl<SodiumGameOptions, Integer> maxTileEntityDistance = OptionImpl.createBuilder(Integer.TYPE, performanceOptionsStorage).setName((Component)Component.m_237115_((String)"xenon.extras.options.culling.tile.distance.horizontal.title")).setTooltip((Component)Component.m_237115_((String)"xenon.extras.options.culling.tile.distance.horizontal.desc")).setControl(option -> new SliderControl((Option<Integer>)option, 16, 256, 8, ControlValueFormatter.biomeBlend())).setBinding((options, value) -> {
            int result = value * value;
            ExtrasConfig.tileEntityCullingDistanceX.set((Object)result);
            ExtrasConfig.tileEntityCullingDistanceXCache = result;
        }, options -> Math.toIntExact(Math.round(Math.sqrt(ExtrasConfig.tileEntityCullingDistanceXCache)))).setImpact(OptionImpact.HIGH).build();
        OptionImpl<SodiumGameOptions, Integer> maxTileEntityDistanceVertical = OptionImpl.createBuilder(Integer.TYPE, performanceOptionsStorage).setName((Component)Component.m_237115_((String)"xenon.extras.options.culling.tile.distance.vertical.title")).setTooltip((Component)Component.m_237115_((String)"xenon.extras.options.culling.tile.distance.vertical.desc")).setControl(option -> new SliderControl((Option<Integer>)option, 16, 64, 4, ControlValueFormatter.biomeBlend())).setBinding((options, value) -> {
            ExtrasConfig.tileEntityCullingDistanceY.set(value);
            ExtrasConfig.tileEntityCullingDistanceYCache = value;
        }, options -> ExtrasConfig.tileEntityCullingDistanceYCache).setImpact(OptionImpact.HIGH).build();
        groups.add(OptionGroup.createBuilder().add(enableTileDistanceChecks).add(maxTileEntityDistance).add(maxTileEntityDistanceVertical).build());
        return ImmutableList.copyOf(groups);
    }
}

