/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemylib.api.blockentity.container.data;

import com.smashingmods.alchemylib.api.blockentity.container.data.AbstractDisplayData;
import com.smashingmods.alchemylib.api.blockentity.processing.AbstractFluidBlockEntity;
import com.smashingmods.alchemylib.api.storage.FluidStorageHandler;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.client.resources.language.I18n;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;

public class FluidDisplayData
extends AbstractDisplayData {
    private final AbstractFluidBlockEntity blockEntity;

    public FluidDisplayData(AbstractFluidBlockEntity pBlockEntity, int pX, int pY, int pWidth, int pHeight) {
        super(pX, pY, pWidth, pHeight);
        this.blockEntity = pBlockEntity;
    }

    @Override
    public int getValue() {
        return this.blockEntity.getFluidStorage().getFluidAmount();
    }

    @Override
    public int getMaxValue() {
        return this.blockEntity.getFluidStorage().getCapacity();
    }

    public FluidStorageHandler getFluidHandler() {
        return (FluidStorageHandler)((Object)this.blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).orElseGet(() -> new FluidStorageHandler(0, FluidStack.EMPTY)));
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        FluidStack fluidStack = this.getFluidHandler().getFluidStack();
        boolean emptyFluid = fluidStack.isFluidEqual(FluidStack.EMPTY);
        String fluidName = emptyFluid ? "" : String.format(" %s", I18n.m_118938_((String)fluidStack.getTranslationKey(), (Object[])new Object[0]).toLowerCase());
        String stored = numberFormat.format(this.getValue());
        String capacity = numberFormat.format(this.getMaxValue());
        return String.format("%s/%s mb%s", stored, capacity, fluidName);
    }
}

