/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.Internal;
import mezz.jei.common.transfer.RecipeTransferUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import org.jetbrains.annotations.Nullable;

public class PreviewTooltipComponent<R>
implements ClientTooltipComponent,
TooltipComponent {
    private static final int UPDATE_INTERVAL_MS = 2000;
    private final IRecipeLayoutDrawable<R> drawable;
    @Nullable
    private IRecipeTransferError transferError;
    private long lastUpdateTime = 0L;

    public PreviewTooltipComponent(IRecipeLayoutDrawable<R> drawable) {
        this.drawable = drawable;
    }

    public int m_142103_() {
        return this.drawable.getRect().m_110091_() + 10;
    }

    public int m_142069_(Font font) {
        return this.drawable.getRect().m_110090_() + 4;
    }

    public void m_183452_(Font font, int x, int y, GuiGraphics guiGraphics) {
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)(x + 2), (float)(y + 5), 0.0f);
        this.drawable.drawRecipe(guiGraphics, 0, 0);
        this.updateTransferError();
        if (this.transferError != null) {
            Rect2i recipeRect = this.drawable.getRect();
            this.transferError.showError(guiGraphics, x, y, this.drawable.getRecipeSlotsView(), recipeRect.m_110085_(), recipeRect.m_110086_());
        }
        pose.m_85849_();
    }

    private void updateTransferError() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime < 2000L) {
            return;
        }
        this.lastUpdateTime = currentTime;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            this.transferError = null;
            return;
        }
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            AbstractContainerMenu container = containerScreen.m_6262_();
            IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
            this.transferError = RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, container, this.drawable, (Player)player).orElse(null);
        } else {
            this.transferError = null;
        }
    }
}

