/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.logic;

import dev.xkmc.cuisinedelight.content.item.BaseFoodItem;
import dev.xkmc.cuisinedelight.content.logic.FoodType;
import dev.xkmc.cuisinedelight.init.CuisineDelight;
import dev.xkmc.l2library.serial.config.BaseConfig;
import dev.xkmc.l2library.serial.config.CollectType;
import dev.xkmc.l2library.serial.config.ConfigCollect;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class IngredientConfig
extends BaseConfig {
    @SerialClass.SerialField
    @ConfigCollect(value=CollectType.COLLECT)
    public ArrayList<IngredientEntry> entries = new ArrayList();
    private final HashMap<Item, IngredientEntry> cache = new HashMap();
    private final HashSet<Item> empty = new HashSet();
    private final ItemStack[][] byType = new ItemStack[FoodType.values().length][];

    public static IngredientConfig get() {
        return (IngredientConfig)CuisineDelight.INGREDIENT.getMerged();
    }

    @Nullable
    public IngredientEntry getEntry(ItemStack stack) {
        if (stack.m_41783_() == null) {
            if (this.empty.contains(stack.m_41720_())) {
                return null;
            }
            if (this.cache.containsKey(stack.m_41720_())) {
                return this.cache.get(stack.m_41720_());
            }
        }
        for (IngredientEntry e : this.entries) {
            if (!e.ingredient.test(stack)) continue;
            if (stack.m_41783_() == null) {
                this.cache.put(stack.m_41720_(), e);
            }
            return e;
        }
        if (stack.m_41783_() == null) {
            this.empty.add(stack.m_41720_());
        }
        return null;
    }

    public ItemStack[] getAll(FoodType type) {
        if (this.byType[type.ordinal()] != null) {
            return this.byType[type.ordinal()];
        }
        this.byType[type.ordinal()] = (ItemStack[])this.entries.stream().filter(e -> e.type == type).flatMap(e -> Arrays.stream(e.ingredient.m_43908_())).map(BaseFoodItem::setIngredientDisplay).toArray(ItemStack[]::new);
        return this.byType[type.ordinal()];
    }

    public static IngredientEntry get(Ingredient ingredient, FoodType type, int min_time, int max_time, int stir_time, float raw_penalty, float overcook_penalty, int size, int nutrition, EffectEntry ... effects) {
        IngredientEntry ans = new IngredientEntry();
        ans.ingredient = ingredient;
        ans.type = type;
        ans.min_time = min_time;
        ans.max_time = max_time;
        ans.stir_time = stir_time;
        ans.raw_penalty = raw_penalty;
        ans.overcook_penalty = overcook_penalty;
        ans.size = size;
        ans.nutrition = nutrition;
        ans.effects.addAll(Arrays.asList(effects));
        return ans;
    }

    public static IngredientConfig build(IngredientEntry ... entries) {
        IngredientConfig ans = new IngredientConfig();
        Collections.addAll(ans.entries, entries);
        return ans;
    }

    @SerialClass
    public static class IngredientEntry {
        @SerialClass.SerialField
        public Ingredient ingredient;
        @SerialClass.SerialField
        public FoodType type;
        @SerialClass.SerialField
        public int min_time;
        @SerialClass.SerialField
        public int max_time;
        @SerialClass.SerialField
        public int stir_time;
        @SerialClass.SerialField
        public float raw_penalty;
        @SerialClass.SerialField
        public float overcook_penalty;
        @SerialClass.SerialField
        public int size;
        @SerialClass.SerialField
        public int nutrition;
        @SerialClass.SerialField
        public ArrayList<EffectEntry> effects = new ArrayList();
    }

    public record EffectEntry(MobEffect effect, int level, int time) {
    }
}

