/*
 * Decompiled with CFR 0.152.
 */
package net.dadamalda.create_compatible_storage;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.dadamalda.create_compatible_storage.CCSTags;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynServerResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public class DynamicTags {
    public static void init() {
        ServerDataGenerator generator = new ServerDataGenerator();
        generator.register();
    }

    public static class ServerDataGenerator
    extends DynServerResourcesGenerator {
        protected ServerDataGenerator() {
            super(new DynamicDataPack(ResourceLocation.parse((String)"create_compatible_storage:everycomp_tags")));
            ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"create"});
            ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"create_compatible_storage"});
        }

        public Logger getLogger() {
            return Moonlight.LOGGER;
        }

        public boolean dependsOnLoadedPacks() {
            return true;
        }

        public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
            super.regenerateDynamicAssets(executor);
            boolean isChestModLoaded = ModList.get().isLoaded("quark") || ModList.get().isLoaded("lolmcv") || ModList.get().isLoaded("woodworks");
            boolean isStoneChestsLoaded = ModList.get().isLoaded("stonechest");
            boolean isFarmersDelightLoaded = ModList.get().isLoaded("farmersdelight");
            boolean isFurnitureRefurbishedLoaded = ModList.get().isLoaded("refurbished_furniture");
            boolean isStorageDelightLoaded = ModList.get().isLoaded("storagedelight");
            executor.accept((resourceManager, resourceSink) -> {
                SimpleTagBuilder chestMountedStorage = SimpleTagBuilder.of(CCSTags.CHEST_MOUNTED_STORAGE);
                Pattern pattern1 = Pattern.compile("^(?:abnww|mcv|q)/[\\w/]+_chest$");
                Pattern pattern2 = Pattern.compile("^sc/[\\w/]+$");
                for (Block b : ForgeRegistries.BLOCKS) {
                    ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)b);
                    if (isChestModLoaded && key != null && key.m_135827_().equals("everycomp") && pattern1.matcher(key.m_135815_()).matches()) {
                        chestMountedStorage.add(key);
                    }
                    if (!isStoneChestsLoaded || key == null || !key.m_135827_().equals("stonezone") || !pattern2.matcher(key.m_135815_()).matches()) continue;
                    chestMountedStorage.add(key);
                }
                resourceSink.addTag(chestMountedStorage, Registries.f_256747_);
            });
            executor.accept((resourceManager, resourceSink) -> {
                SimpleTagBuilder simpleMountedStorage = SimpleTagBuilder.of(CCSTags.SIMPLE_MOUNTED_STORAGE);
                SimpleTagBuilder singleBlockInventories = SimpleTagBuilder.of(CCSTags.SINGLE_BLOCK_INVENTORIES);
                SimpleTagBuilder fdCabinets = SimpleTagBuilder.of(CCSTags.FD_CABINETS);
                SimpleTagBuilder sdCabinetVariants = SimpleTagBuilder.of(CCSTags.SD_CABINET_VARIANTS);
                SimpleTagBuilder sdGlassCabinets = SimpleTagBuilder.of(CCSTags.SD_GLASS_CABINETS);
                SimpleTagBuilder sdBookshelvesWithDoor = SimpleTagBuilder.of(CCSTags.SD_BOOKSHELVES_WITH_DOOR);
                SimpleTagBuilder sdSmallDrawers = SimpleTagBuilder.of(CCSTags.SD_SMALL_DRAWERS);
                SimpleTagBuilder sdDrawersWithBooks = SimpleTagBuilder.of(CCSTags.SD_DRAWERS_WITH_BOOKS);
                SimpleTagBuilder sdDrawersWithDoor = SimpleTagBuilder.of(CCSTags.SD_DRAWERS_WITH_DOOR);
                SimpleTagBuilder sdDrawers = SimpleTagBuilder.of(CCSTags.SD_DRAWERS);
                SimpleTagBuilder frKitchenDrawers = SimpleTagBuilder.of(CCSTags.FR_KITCHEN_DRAWERS);
                SimpleTagBuilder frDrawers = SimpleTagBuilder.of(CCSTags.FR_DRAWERS);
                SimpleTagBuilder frStorageCabinets = SimpleTagBuilder.of(CCSTags.FR_STORAGE_CABINETS);
                SimpleTagBuilder frCrates = SimpleTagBuilder.of(CCSTags.FR_CRATES);
                SimpleTagBuilder frMailboxes = SimpleTagBuilder.of(CCSTags.FR_MAILBOXES);
                Pattern fdCabinetPattern = Pattern.compile("^fd/[\\w/]+_cabinet$");
                Pattern furnitureRefurbishedPattern = Pattern.compile("^rfm/[\\w/]+_(?:drawer|storage_cabinet|crate|mail_box)$");
                Pattern storageDelightPattern = Pattern.compile("^sdl/[\\w/]+$");
                Pattern sdCabinetVariantPattern = Pattern.compile("^sdl/[\\w/]+_(?:single_door_cabinet|cabinet_with_glass_doors)$");
                Pattern sdGlassCabinetPattern = Pattern.compile("^sdl/\\w+/glass_\\w+_cabinet$");
                Pattern sdBookshelfWithDoorPattern = Pattern.compile("^sdl/[\\w/]+_bookshelf_with_door$");
                Pattern sdSmallDrawerPattern = Pattern.compile("^sdl/\\w+/small_\\w+_drawers$");
                Pattern sdDrawerWithBooksPattern = Pattern.compile("^sdl/\\w+/\\w+_drawer_with_books$");
                Pattern sdDrawerWithDoorPattern = Pattern.compile("^sdl/\\w+/\\w+_drawer_with_door$");
                Pattern sdDrawerPattern = Pattern.compile("^sdl/\\w+/\\w+_drawer$");
                Pattern frKitchenDrawerPattern = Pattern.compile("^rfm/\\w+/\\w+_kitchen_drawer$");
                Pattern frDrawerPattern = Pattern.compile("^rfm/\\w+/\\w+_drawer$");
                Pattern frStorageCabinetPattern = Pattern.compile("^rfm/\\w+/\\w+_storage_cabinet$");
                Pattern frCratePattern = Pattern.compile("^rfm/\\w+/\\w+_crate$");
                Pattern frMailboxPattern = Pattern.compile("^rfm/\\w+/\\w+_mail_box$");
                for (Block b : ForgeRegistries.BLOCKS) {
                    ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)b);
                    if (isFarmersDelightLoaded && key != null && key.m_135827_().equals("everycomp") && fdCabinetPattern.matcher(key.m_135815_()).matches()) {
                        simpleMountedStorage.add(key);
                        singleBlockInventories.add(key);
                        fdCabinets.add(key);
                    }
                    if (isStorageDelightLoaded && key != null && key.m_135827_().equals("everycomp") && storageDelightPattern.matcher(key.m_135815_()).matches()) {
                        simpleMountedStorage.add(key);
                        singleBlockInventories.add(key);
                        if (sdCabinetVariantPattern.matcher(key.m_135815_()).matches()) {
                            sdCabinetVariants.add(key);
                        } else if (sdGlassCabinetPattern.matcher(key.m_135815_()).matches()) {
                            sdGlassCabinets.add(key);
                        } else if (sdBookshelfWithDoorPattern.matcher(key.m_135815_()).matches()) {
                            sdBookshelvesWithDoor.add(key);
                        } else if (sdSmallDrawerPattern.matcher(key.m_135815_()).matches()) {
                            sdSmallDrawers.add(key);
                        } else if (sdDrawerWithBooksPattern.matcher(key.m_135815_()).matches()) {
                            sdDrawersWithBooks.add(key);
                        } else if (sdDrawerWithDoorPattern.matcher(key.m_135815_()).matches()) {
                            sdDrawersWithDoor.add(key);
                        } else if (sdDrawerPattern.matcher(key.m_135815_()).matches()) {
                            sdDrawers.add(key);
                        }
                    }
                    if (!isFurnitureRefurbishedLoaded || key == null || !key.m_135827_().equals("everycomp") || !furnitureRefurbishedPattern.matcher(key.m_135815_()).matches()) continue;
                    simpleMountedStorage.add(key);
                    singleBlockInventories.add(key);
                    if (frKitchenDrawerPattern.matcher(key.m_135815_()).matches()) {
                        frKitchenDrawers.add(key);
                        continue;
                    }
                    if (frDrawerPattern.matcher(key.m_135815_()).matches()) {
                        frDrawers.add(key);
                        continue;
                    }
                    if (frStorageCabinetPattern.matcher(key.m_135815_()).matches()) {
                        frStorageCabinets.add(key);
                        continue;
                    }
                    if (frCratePattern.matcher(key.m_135815_()).matches()) {
                        frCrates.add(key);
                        continue;
                    }
                    if (!frMailboxPattern.matcher(key.m_135815_()).matches()) continue;
                    frMailboxes.add(key);
                }
                resourceSink.addTag(simpleMountedStorage, Registries.f_256747_);
                resourceSink.addTag(singleBlockInventories, Registries.f_256747_);
                resourceSink.addTag(fdCabinets, Registries.f_256747_);
                resourceSink.addTag(sdCabinetVariants, Registries.f_256747_);
                resourceSink.addTag(sdGlassCabinets, Registries.f_256747_);
                resourceSink.addTag(sdBookshelvesWithDoor, Registries.f_256747_);
                resourceSink.addTag(sdSmallDrawers, Registries.f_256747_);
                resourceSink.addTag(sdDrawersWithBooks, Registries.f_256747_);
                resourceSink.addTag(sdDrawersWithDoor, Registries.f_256747_);
                resourceSink.addTag(sdDrawers, Registries.f_256747_);
                resourceSink.addTag(frKitchenDrawers, Registries.f_256747_);
                resourceSink.addTag(frDrawers, Registries.f_256747_);
                resourceSink.addTag(frStorageCabinets, Registries.f_256747_);
                resourceSink.addTag(frCrates, Registries.f_256747_);
                resourceSink.addTag(frMailboxes, Registries.f_256747_);
            });
        }
    }
}

