/*
 * Decompiled with CFR 0.152.
 */
package com.getitemfromblock.create_tweaked_controllers.input;

import com.getitemfromblock.create_tweaked_controllers.CreateTweakedControllers;
import com.getitemfromblock.create_tweaked_controllers.gui.InputConfig.GenericInputScreen;
import com.getitemfromblock.create_tweaked_controllers.gui.InputConfig.MouseAxisScreen;
import com.getitemfromblock.create_tweaked_controllers.input.GenericInput;
import com.getitemfromblock.create_tweaked_controllers.input.MouseCursorHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MouseAxisInput
implements GenericInput {
    public boolean useVelocity = false;
    public boolean isYAxis = false;
    public float minBound = 0.0f;
    public float maxBound = 1000.0f;

    public MouseAxisInput(boolean axis, float min, float max, boolean useVel) {
        this.isYAxis = axis;
        this.minBound = min;
        this.maxBound = max;
        this.useVelocity = useVel;
    }

    public MouseAxisInput() {
    }

    @Override
    public boolean GetButtonValue() {
        return this.GetAxisValue() >= 0.5f;
    }

    @Override
    public float GetAxisValue() {
        if (!this.IsInputValid()) {
            return 0.0f;
        }
        float v = this.isYAxis ? MouseCursorHandler.GetY(this.useVelocity) : MouseCursorHandler.GetX(this.useVelocity);
        if ((v = (v - this.minBound) / (this.maxBound - this.minBound)) < 0.0f) {
            v = 0.0f;
        }
        if (v > 1.0f) {
            v = 1.0f;
        }
        return v;
    }

    @Override
    public MutableComponent GetDisplayName() {
        Object a = "";
        if (this.minBound >= 0.0f && this.maxBound >= 0.0f) {
            a = "+";
        } else if (this.minBound <= 0.0f && this.maxBound <= 0.0f) {
            a = "-";
        }
        a = (String)a + (this.isYAxis ? (char)'Y' : 'X');
        if (this.useVelocity) {
            return CreateTweakedControllers.translateDirect("gui_input_cursor_vel", a);
        }
        return CreateTweakedControllers.translateDirect("gui_input_cursor_pos", a);
    }

    @Override
    public boolean IsInputValid() {
        return this.minBound != this.maxBound;
    }

    @Override
    public void Serialize(DataOutputStream buf) throws IOException {
        byte val = (byte)((this.useVelocity ? 1 : 0) | (this.isYAxis ? 2 : 0));
        buf.writeByte(val);
        buf.writeFloat(this.minBound);
        buf.writeFloat(this.maxBound);
    }

    @Override
    public void Deserialize(DataInputStream buf) throws IOException {
        Byte val = buf.readByte();
        this.useVelocity = (val & 1) != 0;
        this.isYAxis = (val & 2) != 0;
        this.minBound = buf.readFloat();
        this.maxBound = buf.readFloat();
    }

    @Override
    public GenericInput.InputType GetType() {
        return GenericInput.InputType.MOUSE_AXIS;
    }

    @Override
    public int GetValue() {
        return this.isYAxis ? 1 : 0;
    }

    @Override
    public GenericInputScreen OpenConfigScreen(Screen previous, Component comp) {
        return new MouseAxisScreen(previous, comp, this);
    }

    public float GetRawInput() {
        if (!this.IsInputValid()) {
            return 0.0f;
        }
        return this.isYAxis ? MouseCursorHandler.GetY(this.useVelocity) : MouseCursorHandler.GetX(this.useVelocity);
    }
}

