/*
 * Decompiled with CFR 0.152.
 */
package com.getitemfromblock.create_tweaked_controllers.input;

import com.getitemfromblock.create_tweaked_controllers.CreateTweakedControllers;
import com.getitemfromblock.create_tweaked_controllers.gui.InputConfig.GenericInputScreen;
import com.getitemfromblock.create_tweaked_controllers.gui.InputConfig.JoystickAxisScreen;
import com.getitemfromblock.create_tweaked_controllers.input.GenericInput;
import com.getitemfromblock.create_tweaked_controllers.input.JoystickInputs;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class JoystickAxisInput
implements GenericInput {
    public int axisID = -1;
    public float minBound = 0.0f;
    public float maxBound = 1.0f;

    public JoystickAxisInput(int axisID) {
        this.axisID = axisID;
    }

    public JoystickAxisInput() {
    }

    public JoystickAxisInput(int axisID, float min, float max) {
        this.axisID = axisID;
        this.minBound = min;
        this.maxBound = max;
    }

    @Override
    public boolean GetButtonValue() {
        return this.GetAxisValue() >= 0.5f;
    }

    @Override
    public float GetAxisValue() {
        if (!this.IsInputValid()) {
            return 0.0f;
        }
        float v = (JoystickInputs.GetAxis(this.axisID) - this.minBound) / (this.maxBound - this.minBound);
        if (v < 0.0f) {
            v = 0.0f;
        }
        if (v > 1.0f) {
            v = 1.0f;
        }
        return v;
    }

    @Override
    public MutableComponent GetDisplayName() {
        if (this.minBound >= 0.0f && this.maxBound >= 0.0f) {
            return CreateTweakedControllers.translateDirect("gui_input_joystick_axis", "+" + this.axisID);
        }
        if (this.minBound <= 0.0f && this.maxBound <= 0.0f) {
            return CreateTweakedControllers.translateDirect("gui_input_joystick_axis", "-" + this.axisID);
        }
        return CreateTweakedControllers.translateDirect("gui_input_joystick_axis", "" + this.axisID);
    }

    @Override
    public boolean IsInputValid() {
        return this.axisID < JoystickInputs.GetAxisCount() && this.axisID >= 0 && this.minBound != this.maxBound;
    }

    @Override
    public void Serialize(DataOutputStream buf) throws IOException {
        buf.writeFloat(this.minBound);
        buf.writeFloat(this.maxBound);
        buf.writeInt(this.axisID);
    }

    @Override
    public void Deserialize(DataInputStream buf) throws IOException {
        this.minBound = buf.readFloat();
        this.maxBound = buf.readFloat();
        this.axisID = buf.readInt();
    }

    @Override
    public GenericInput.InputType GetType() {
        return GenericInput.InputType.JOYSTICK_AXIS;
    }

    @Override
    public int GetValue() {
        return this.axisID;
    }

    @Override
    public GenericInputScreen OpenConfigScreen(Screen previous, Component comp) {
        return new JoystickAxisScreen(previous, comp, this);
    }

    public float GetRawInput() {
        if (!this.IsInputValid()) {
            return 0.0f;
        }
        return JoystickInputs.GetAxis(this.axisID);
    }
}

