/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.loot.modification;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.loot.modification.LootModifierSerializers;
import com.teamabnormals.blueprint.core.util.modification.ObjectModificationManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="blueprint")
public final class LootModificationManager
extends ObjectModificationManager<LootTable, Gson, Pair<Gson, LootDataManager>> {
    public static final String TARGET_DIRECTORY = "loot_tables";
    private static final Gson GSON = Deserializers.m_78800_().registerTypeAdapter(LootPool.class, (Object)new LootPoolSerializer()).create();
    private static LootModificationManager INSTANCE = null;

    private LootModificationManager(LootDataManager lootDataManager) {
        super(GSON, TARGET_DIRECTORY, "Loot", LootModifierSerializers.REGISTRY, Pair.of((Object)GSON, (Object)lootDataManager), true, true);
    }

    @Nullable
    public static LootModificationManager getInstance() {
        return INSTANCE;
    }

    static {
        LootModificationManager.registerInitializer("LootDataManager", (registryAccess, commandSelection, reloadableServerResources) -> {
            INSTANCE = new LootModificationManager(reloadableServerResources.m_278801_());
            return INSTANCE;
        });
    }

    static class LootPoolSerializer
    extends LootPool.Serializer {
        private static Constructor<LootPool> LOOT_POOL_CONSTRUCTOR;

        LootPoolSerializer() {
        }

        public LootPool deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)element, (String)"loot pool");
            LootPoolEntryContainer[] alootentry = (LootPoolEntryContainer[])GsonHelper.m_13836_((JsonObject)jsonobject, (String)"entries", (JsonDeserializationContext)context, LootPoolEntryContainer[].class);
            LootItemCondition[] ailootcondition = (LootItemCondition[])GsonHelper.m_13845_((JsonObject)jsonobject, (String)"conditions", (Object)new LootItemCondition[0], (JsonDeserializationContext)context, LootItemCondition[].class);
            LootItemFunction[] ailootfunction = (LootItemFunction[])GsonHelper.m_13845_((JsonObject)jsonobject, (String)"functions", (Object)new LootItemFunction[0], (JsonDeserializationContext)context, LootItemFunction[].class);
            NumberProvider rolls = (NumberProvider)GsonHelper.m_13836_((JsonObject)jsonobject, (String)"rolls", (JsonDeserializationContext)context, NumberProvider.class);
            NumberProvider bonusRolls = (NumberProvider)GsonHelper.m_13845_((JsonObject)jsonobject, (String)"bonus_rolls", (Object)ConstantValue.m_165692_((float)0.0f), (JsonDeserializationContext)context, NumberProvider.class);
            if (jsonobject.has("name")) {
                try {
                    return LOOT_POOL_CONSTRUCTOR.newInstance(alootentry, ailootcondition, ailootfunction, rolls, bonusRolls, GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name"));
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    e.printStackTrace();
                    throw new JsonParseException("Could not initialize a new loot pool: " + e);
                }
            }
            throw new JsonParseException("Missing name for loot pool!");
        }

        static {
            try {
                LOOT_POOL_CONSTRUCTOR = LootPool.class.getDeclaredConstructor(LootPoolEntryContainer[].class, LootItemCondition[].class, LootItemFunction[].class, NumberProvider.class, NumberProvider.class, String.class);
                LOOT_POOL_CONSTRUCTOR.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }
}

