/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.item.hatchet;

import net.dakotapride.garnished.item.hatchet.HatchetToolItem;
import net.dakotapride.garnished.registry.GarnishedEnchantments;
import net.dakotapride.garnished.registry.GarnishedTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Unique;

public class HatchetUtils {
    static Enchantment salvaging = (Enchantment)GarnishedEnchantments.SALVAGING.get();
    static Enchantment ravaging = (Enchantment)GarnishedEnchantments.RAVAGING.get();
    static Enchantment striking = (Enchantment)GarnishedEnchantments.STRIKING.get();
    static Enchantment quickStep = (Enchantment)GarnishedEnchantments.QUICK_STEP.get();
    static Enchantment leechingCurse = (Enchantment)GarnishedEnchantments.LEECHING_CURSE.get();
    public static final RandomSource random = RandomSource.m_216327_();

    public static boolean isAffectedByRavaging(Entity entity) {
        return entity.m_6095_().m_204039_(GarnishedTags.IS_AFFECTED_BY_RAVAGING);
    }

    public static boolean isAffectedBySalvaging(Entity entity) {
        return entity.m_6095_().m_204039_(GarnishedTags.IS_AFFECTED_BY_SALVAGING);
    }

    public static boolean hasRavaging(LivingEntity entity) {
        return HatchetUtils.hasEnchantment(ravaging, entity);
    }

    public static boolean hasSalvaging(LivingEntity entity) {
        return HatchetUtils.hasEnchantment(salvaging, entity);
    }

    public static boolean hasStriking(LivingEntity entity) {
        return HatchetUtils.hasEnchantment(striking, entity);
    }

    public static boolean hasLeechingCurse(LivingEntity entity) {
        return HatchetUtils.hasEnchantment(leechingCurse, entity);
    }

    public static boolean hasQuickStep(LivingEntity entity) {
        return HatchetUtils.hasEnchantment(quickStep, entity);
    }

    public static boolean canApplyRavagingEffects(LivingEntity entity) {
        return entity.m_21205_().m_204117_(GarnishedTags.HATCHETS_TAG) && HatchetUtils.hasEnchantment(ravaging, entity) && entity.m_21223_() <= entity.m_21233_() / 2.0f;
    }

    public static boolean canApplyQuickStepEffects(LivingEntity entity) {
        return entity.m_21205_().m_204117_(GarnishedTags.HATCHETS_TAG) && HatchetUtils.hasEnchantment(quickStep, entity) && entity.m_21223_() <= entity.m_21233_() / 2.0f;
    }

    public static boolean canBeUsedToStripLogs(ItemStack stack) {
        return stack.m_41720_() instanceof AxeItem || stack.m_41720_() instanceof HatchetToolItem;
    }

    @Unique
    private static boolean hasEnchantment(Enchantment enchantment, LivingEntity entity) {
        return EnchantmentHelper.m_44836_((Enchantment)enchantment, (LivingEntity)entity) > 0;
    }
}

