/*
 * Decompiled with CFR 0.152.
 */
package com.cak.trading_floor.content.trading_depot;

import com.cak.trading_floor.content.trading_depot.CommonTradingDepotBlock;
import com.cak.trading_floor.content.trading_depot.CommonTradingDepotBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.ArrayList;
import java.util.Random;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TradingDepotRenderer
extends SmartBlockEntityRenderer<CommonTradingDepotBlockEntity> {
    public TradingDepotRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(CommonTradingDepotBlockEntity blockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)blockEntity, partialTicks, ms, buffer, light, overlay);
        TransportedItemStack transported = blockEntity.getCommonTradingDepotBehaviour().getOffer();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        Vec3 itemPosition = VecHelper.getCenterOf((Vec3i)blockEntity.m_58899_());
        ms.m_85836_();
        ms.m_85837_(0.5, 1.0, 0.5);
        ArrayList<TransportedItemStack> tisStacks = new ArrayList<TransportedItemStack>(blockEntity.getCommonTradingDepotBehaviour().getIncoming());
        if (transported != null) {
            tisStacks.add(transported);
        }
        for (TransportedItemStack tis : tisStacks) {
            ms.m_85836_();
            msr.nudge(0);
            float offset = Mth.m_14179_((float)partialTicks, (float)tis.prevBeltPosition, (float)tis.beltPosition);
            float sideOffset = Mth.m_14179_((float)partialTicks, (float)tis.prevSideOffset, (float)tis.sideOffset);
            if (tis.insertedFrom.m_122434_().m_122479_()) {
                Vec3 offsetVec = Vec3.m_82528_((Vec3i)tis.insertedFrom.m_122424_().m_122436_()).m_82490_((double)(0.5f - offset));
                ms.m_85837_(offsetVec.f_82479_, offsetVec.f_82480_, offsetVec.f_82481_);
                boolean bl = tis.insertedFrom.m_122427_().m_122434_() == Direction.Axis.X;
            }
            ItemStack itemStack = tis.stack;
            int angle = tis.angle;
            Random r = new Random(0L);
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees((float)(90 - ((Direction)blockEntity.m_58900_().m_61143_((Property)CommonTradingDepotBlock.f_54117_)).m_122416_() * 90))).rotateZDegrees(22.5f);
            TradingDepotRenderer.renderItem(blockEntity.m_58904_(), ms, buffer, light, overlay, itemStack, angle, r);
            ms.m_85849_();
        }
        for (int i = 0; i < blockEntity.getCommonTradingDepotBehaviour().getResults().size(); ++i) {
            ItemStack stack = blockEntity.getCommonTradingDepotBehaviour().getResults().get(i);
            if (stack.m_41619_()) continue;
            ms.m_85836_();
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees((float)(90 - ((Direction)blockEntity.m_58900_().m_61143_((Property)CommonTradingDepotBlock.f_54117_)).m_122416_() * 90))).rotateZDegrees(22.5f);
            msr.nudge(i);
            msr.rotateYDegrees((215.0f + 45.0f * (float)i) % 360.0f);
            ms.m_85837_(0.35, 0.01 / (double)(i + 1), 0.0);
            Random r = new Random(i + 1);
            int angle = (int)(360.0f * r.nextFloat());
            TradingDepotRenderer.renderItem(blockEntity.m_58904_(), ms, buffer, light, overlay, stack, angle, r);
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    public static void renderItem(Level level, PoseStack ms, MultiBufferSource buffer, int light, int overlay, ItemStack itemStack, int angle, Random r) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        int count = Mth.m_14173_((int)itemStack.m_41613_()) / 2;
        boolean blockItem = itemRenderer.m_174264_(itemStack, null, null, 0).m_7539_();
        ms.m_85836_();
        msr.rotateYDegrees((float)angle);
        for (int i = 0; i <= count; ++i) {
            ms.m_85836_();
            if (blockItem) {
                ms.m_252880_(r.nextFloat() * 0.0625f * (float)i, 0.0f, r.nextFloat() * 0.0625f * (float)i);
            }
            ms.m_85841_(0.5f, 0.5f, 0.5f);
            if (!blockItem) {
                ms.m_252880_(0.0f, -0.1875f, 0.0f);
                msr.rotateXDegrees(90.0f);
            }
            itemRenderer.m_269128_(itemStack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, level, 0);
            ms.m_85849_();
            if (!blockItem) {
                msr.rotateYDegrees(10.0f);
            }
            ms.m_85837_(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
        }
        ms.m_85849_();
    }
}

