/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.common.items;

import com.smashingmods.chemlib.api.Chemical;
import com.smashingmods.chemlib.api.Element;
import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.common.blocks.ChemicalBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChemicalBlockItem
extends BlockItem
implements Chemical {
    private final ChemicalBlock block;

    public ChemicalBlockItem(ChemicalBlock pBlock, Item.Properties pProperties) {
        super((Block)pBlock, pProperties);
        this.block = pBlock;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        Chemical chemical = this.getChemical();
        if (chemical instanceof Element) {
            Element element = (Element)chemical;
            pTooltipComponents.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(String.format("%s (%d)", this.getAbbreviation(), element.getAtomicNumber()))).m_130940_(ChatFormatting.DARK_AQUA));
            pTooltipComponents.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(element.getGroupName())).m_130940_(ChatFormatting.GRAY));
        }
    }

    public Chemical getChemical() {
        return this.block.getChemical();
    }

    @Override
    public String getChemicalName() {
        return this.block.getChemicalName();
    }

    @Override
    public String getAbbreviation() {
        return this.getChemical().getAbbreviation();
    }

    @Override
    public MatterState getMatterState() {
        return this.getChemical().getMatterState();
    }

    @Override
    public String getChemicalDescription() {
        return this.getChemical().getChemicalDescription();
    }

    @Override
    public List<MobEffectInstance> getEffects() {
        return this.getChemical().getEffects();
    }

    @Override
    public int getColor() {
        return this.clampMinColorValue(this.getChemical().getColor(), 68);
    }

    public int getColor(ItemStack pItemStack, int pTintIndex) {
        return this.getColor();
    }
}

