/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.nebs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.infernalstudios.nebs.NekosEnchantedBooks;
import org.jetbrains.annotations.Nullable;

public final class EnchantedBookOverrides
extends ItemOverrides {
    static final String ENCHANTED_BOOK_UNBAKED_MODEL_NAME = "minecraft:item/enchanted_book";
    private static final Set<String> PREPARED_ENCHANTMENTS = new HashSet<String>();
    private static final Set<ResourceLocation> PREPARED_MODELS = new HashSet<ResourceLocation>();
    private final ItemOverrides base;
    private final Map<String, BakedModel> overrides;

    static ResourceLocation locationFrom(String enchantment) {
        return new ResourceLocation("nebs", "item/" + enchantment.replace(".", "/"));
    }

    public static ItemOverrides of(ItemOverrides base, String location, ModelBaker baker) {
        if (!ENCHANTED_BOOK_UNBAKED_MODEL_NAME.equals(location)) {
            return base;
        }
        try {
            return new EnchantedBookOverrides(base, baker);
        }
        catch (RuntimeException e) {
            NekosEnchantedBooks.LOGGER.error("Failed to bake custom enchanted book overrides!", (Throwable)e);
            return base;
        }
    }

    public static ItemOverrides of(ItemOverrides base, String location, final ModelBaker baker, final Function<Material, TextureAtlasSprite> spriteGetter) {
        if (!ENCHANTED_BOOK_UNBAKED_MODEL_NAME.equals(location)) {
            return base;
        }
        try {
            return new EnchantedBookOverrides(base, new ModelBaker(){

                public UnbakedModel m_245361_(ResourceLocation location) {
                    return baker.m_245361_(location);
                }

                @Nullable
                public BakedModel m_245240_(ResourceLocation location, ModelState state) {
                    return baker.bake(location, state, this.getModelTextureGetter());
                }

                @Nullable
                public BakedModel bake(ResourceLocation location, ModelState state, Function<Material, TextureAtlasSprite> sprites) {
                    return baker.bake(location, state, sprites);
                }

                public Function<Material, TextureAtlasSprite> getModelTextureGetter() {
                    return spriteGetter;
                }
            });
        }
        catch (RuntimeException e) {
            NekosEnchantedBooks.LOGGER.error("Failed to bake custom enchanted book overrides!", (Throwable)e);
            return base;
        }
    }

    private EnchantedBookOverrides(ItemOverrides base, ModelBaker baker) {
        this.base = base;
        this.overrides = EnchantedBookOverrides.bakeOverrides(baker);
    }

    private static Map<String, BakedModel> bakeOverrides(ModelBaker baker) {
        HashMap<String, BakedModel> overrides = new HashMap<String, BakedModel>(PREPARED_ENCHANTMENTS.size());
        TreeSet failed = new TreeSet();
        PREPARED_ENCHANTMENTS.forEach(enchantment -> {
            ResourceLocation model = EnchantedBookOverrides.locationFrom(enchantment);
            if (!PREPARED_MODELS.contains(model)) {
                if (!NekosEnchantedBooks.NON_ENCHANTMENTS.contains(enchantment)) {
                    failed.add(enchantment);
                }
                return;
            }
            BakedModel baked = baker.m_245240_(model, (ModelState)BlockModelRotation.X0_Y0);
            if (baked == null) {
                failed.add(enchantment);
                return;
            }
            overrides.put((String)enchantment, baked);
        });
        if (!failed.isEmpty()) {
            NekosEnchantedBooks.LOGGER.warn("Missing, or failed to load, enchanted book models for the following enchantments: [{}]", (Object)String.join((CharSequence)", ", failed));
        } else {
            NekosEnchantedBooks.LOGGER.info("Successfully loaded enchanted book models for all available enchantments");
        }
        return overrides;
    }

    static void prepare(Iterable<Enchantment> enchantments, Consumer<ResourceLocation> resolver) {
        enchantments.forEach(e -> {
            String enchantment = NekosEnchantedBooks.idOf(e);
            PREPARED_ENCHANTMENTS.add(enchantment);
            ResourceLocation model = EnchantedBookOverrides.locationFrom(enchantment);
            if (Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation(model.m_135827_(), "models/" + model.m_135815_() + ".json")).isEmpty()) {
                return;
            }
            PREPARED_MODELS.add(model);
            resolver.accept(model);
        });
    }

    @Nullable
    public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        for (Enchantment enchantment : EnchantedBookOverrides.getEnchantments(stack)) {
            String key = NekosEnchantedBooks.idOf(enchantment);
            if (!this.overrides.containsKey(key)) continue;
            return this.overrides.get(key);
        }
        return this.base.m_173464_(model, stack, level, entity, seed);
    }

    private static Iterable<Enchantment> getEnchantments(ItemStack stack) {
        return EnchantmentHelper.m_44831_((ItemStack)stack).keySet();
    }
}

