/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.nebs;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.infernalstudios.nebs.EnchantedBookOverrides;

public class EnchantedBookModelProvider
extends ItemModelProvider {
    private static final String OVERRIDES_PATH = "assets/nebs/overrides.json";
    private static final String EXPECTED_PATH = "assets/nebs/textures/item";
    private static final ModelFile ENCHANTED_BOOK_MODEL = new ModelFile.UncheckedModelFile("minecraft:item/enchanted_book");
    private static final String ENCHANTED_BOOK_TEXTURE_KEY = "layer0";
    private Map<String, List<String>> overrides = Collections.emptyMap();

    protected EnchantedBookModelProvider(PackOutput output, String modId, ExistingFileHelper existingFileHelper) {
        super(output, modId, existingFileHelper);
    }

    public String m_6055_() {
        return "Enchanted Book Item Models";
    }

    protected final void registerModels() {
        this.loadOverrides();
        this.listResources(EXPECTED_PATH).map(Path::toString).filter(s -> s.endsWith(".png")).map(s -> s.substring(s.indexOf(EXPECTED_PATH) + "assets/nebs/textures/item/".length(), s.length() - ".png".length()).replace("/", ".")).forEach(this::generateModel);
    }

    private void generateModel(String name) {
        this.generateModel(name, name);
        for (String override : this.overrides.getOrDefault(name, Collections.emptyList())) {
            this.generateModel(name, override);
        }
    }

    private void generateModel(String texture, String destination) {
        ResourceLocation textureLoc = EnchantedBookOverrides.locationFrom(texture);
        ResourceLocation destLoc = EnchantedBookOverrides.locationFrom(destination);
        if (!this.existingFileHelper.exists(textureLoc, PackType.CLIENT_RESOURCES, ".png", "textures")) {
            throw new IllegalStateException(texture + " book texture not found, yet it was found as a resource earlier...");
        }
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(destLoc.m_135815_())).parent(ENCHANTED_BOOK_MODEL)).texture(ENCHANTED_BOOK_TEXTURE_KEY, textureLoc);
    }

    private void loadOverrides() {
        try (InputStream file = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(OVERRIDES_PATH);){
            if (file == null) {
                return;
            }
            try (InputStreamReader input = new InputStreamReader(file, StandardCharsets.UTF_8);){
                this.overrides = (Map)new Gson().fromJson((Reader)new BufferedReader(input), new TypeToken<Map<String, List<String>>>(){}.getType());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Stream<Path> listResources(String path) {
        try {
            URL resourceUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(path);
            if (resourceUrl == null) {
                throw new FileSystemNotFoundException("No resources found in \"%s\"".formatted(path));
            }
            Path resourcePath = Paths.get(resourceUrl.toURI());
            if (Files.isDirectory(resourcePath, new LinkOption[0])) {
                return Files.walk(resourcePath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
            }
            if (resourceUrl.getProtocol().equals("jar")) {
                return Files.walk(FileSystems.newFileSystem(resourceUrl.toURI(), Collections.emptyMap()).getPath(path, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
            }
            throw new IOException("Unsupported resource protocol \"%s\"".formatted(resourceUrl.getProtocol()));
        }
        catch (IOException | URISyntaxException | FileSystemNotFoundException e) {
            throw new RuntimeException("Failed to get resources in \"%s\"".formatted(path), e);
        }
    }
}

