/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.boatload.core.data.server;

import com.teamabnormals.boatload.core.api.BoatloadBoatType;
import com.teamabnormals.boatload.core.other.BoatloadUtil;
import com.teamabnormals.boatload.core.registry.BoatloadItems;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;

public class BoatloadRecipeProvider
extends RecipeProvider {
    public static final ModLoadedCondition BOATLOADED = new ModLoadedCondition("boatload");

    public BoatloadRecipeProvider(PackOutput output) {
        super(output);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        BoatloadRecipeProvider.m_126021_(consumer, (ItemLike)((ItemLike)BoatloadItems.CRIMSON_BOAT.get()), (ItemLike)Blocks.f_50655_);
        BoatloadRecipeProvider.m_126021_(consumer, (ItemLike)((ItemLike)BoatloadItems.WARPED_BOAT.get()), (ItemLike)Blocks.f_50656_);
        BoatloadRecipeProvider.chestBoat(consumer, (ItemLike)BoatloadItems.CRIMSON_CHEST_BOAT.get(), (ItemLike)BoatloadItems.CRIMSON_BOAT.get());
        BoatloadRecipeProvider.chestBoat(consumer, (ItemLike)BoatloadItems.WARPED_CHEST_BOAT.get(), (ItemLike)BoatloadItems.WARPED_BOAT.get());
        BoatloadUtil.getFurnaceBoats().forEach(boat -> BoatloadRecipeProvider.furnaceBoat(consumer, (ItemLike)boat, (ItemLike)boat.getType().boat().get()));
        BoatloadUtil.getLargeBoats().forEach(boat -> BoatloadRecipeProvider.largeBoat(consumer, (ItemLike)boat, (ItemLike)boat.getType().boat().get(), (ItemLike)boat.getType().planks().get()));
    }

    public static void boatRecipes(Consumer<FinishedRecipe> consumer, BoatloadBoatType boatType) {
        BoatloadRecipeProvider.boatRecipes(consumer, (ItemLike)boatType.boat().get(), (ItemLike)boatType.chestBoat().get(), (ItemLike)boatType.furnaceBoat().get(), (ItemLike)boatType.largeBoat().get(), (ItemLike)boatType.planks().get());
    }

    public static void boatRecipes(Consumer<FinishedRecipe> consumer, ItemLike boat, ItemLike chestBoat, ItemLike furnaceBoat, ItemLike largeBoat, ItemLike planks) {
        BoatloadRecipeProvider.m_126021_(consumer, (ItemLike)boat, (ItemLike)planks);
        BoatloadRecipeProvider.chestBoat(consumer, chestBoat, boat);
        BoatloadRecipeProvider.conditionalRecipe(consumer, (ICondition)BOATLOADED, RecipeCategory.TRANSPORTATION, (RecipeBuilder)BoatloadRecipeProvider.furnaceBoatBuilder(furnaceBoat, boat));
        BoatloadRecipeProvider.conditionalRecipe(consumer, (ICondition)BOATLOADED, RecipeCategory.TRANSPORTATION, (RecipeBuilder)BoatloadRecipeProvider.largeBoatBuilder(largeBoat, boat, planks));
    }

    public static void chestBoat(Consumer<FinishedRecipe> consumer, ItemLike chestBoat, ItemLike boat) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)chestBoat).m_206419_(Tags.Items.CHESTS_WOODEN).m_126209_(boat).m_126145_("chest_boat").m_126132_("has_boat", (CriterionTriggerInstance)BoatloadRecipeProvider.m_206406_((TagKey)ItemTags.f_13155_)).m_176498_(consumer);
    }

    public static void furnaceBoat(Consumer<FinishedRecipe> consumer, ItemLike furnaceBoat, ItemLike boat) {
        BoatloadRecipeProvider.furnaceBoatBuilder(furnaceBoat, boat).m_176498_(consumer);
    }

    public static ShapelessRecipeBuilder furnaceBoatBuilder(ItemLike furnaceBoat, ItemLike boat) {
        return ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)furnaceBoat).m_126209_((ItemLike)Blocks.f_50094_).m_126209_(boat).m_126145_("furnace_boat").m_126132_("has_boat", (CriterionTriggerInstance)BoatloadRecipeProvider.m_206406_((TagKey)ItemTags.f_13155_));
    }

    public static void largeBoat(Consumer<FinishedRecipe> consumer, ItemLike largeBoat, ItemLike boat, ItemLike planks) {
        BoatloadRecipeProvider.largeBoatBuilder(largeBoat, boat, planks).m_176498_(consumer);
    }

    public static ShapedRecipeBuilder largeBoatBuilder(ItemLike largeBoat, ItemLike boat, ItemLike planks) {
        return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)largeBoat).m_126127_(Character.valueOf('#'), planks).m_126127_(Character.valueOf('B'), boat).m_126130_("#B#").m_126130_("###").m_126145_("large_boat").m_126132_("has_boat", (CriterionTriggerInstance)BoatloadRecipeProvider.m_206406_((TagKey)ItemTags.f_13155_));
    }

    public static void conditionalRecipe(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory recipeCategory, RecipeBuilder recipe) {
        BoatloadRecipeProvider.conditionalRecipe(consumer, condition, recipeCategory, recipe, RecipeBuilder.m_176493_((ItemLike)recipe.m_142372_()));
    }

    public static void conditionalRecipe(Consumer<FinishedRecipe> consumer, ICondition condition, RecipeCategory recipeCategory, RecipeBuilder recipe, ResourceLocation id) {
        ConditionalRecipe.builder().addCondition(condition).addRecipe(consumer1 -> recipe.m_126140_(consumer1, id)).generateAdvancement(new ResourceLocation(id.m_135827_(), "recipes/" + recipeCategory.m_247710_() + "/" + id.m_135815_())).build(consumer, id);
    }
}

