/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.darkhax.bookshelf.api.Services;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import org.joml.Matrix4f;

public interface RenderHelper {
    public static final RenderHelper INSTANCE = Services.load(RenderHelper.class);

    public static RenderHelper get() {
        return INSTANCE;
    }

    public void renderFluidBox(PoseStack var1, FluidState var2, Level var3, BlockPos var4, MultiBufferSource var5, int var6, int var7);

    default public int[] argb(int color) {
        int[] colors = new int[]{color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return colors;
    }

    default public void renderBox(VertexConsumer builder, PoseStack stack, TextureAtlasSprite sprite, int light, int overlay, int[] color) {
        this.renderBox(builder, stack.m_85850_().m_252922_(), sprite, light, overlay, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, color);
    }

    default public void renderBox(VertexConsumer builder, PoseStack stack, TextureAtlasSprite sprite, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {
        this.renderBox(builder, stack.m_85850_().m_252922_(), sprite, light, overlay, x1, x2, y1, y2, z1, z2, color);
    }

    default public void renderBox(VertexConsumer builder, Matrix4f pos, TextureAtlasSprite sprite, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {
        this.renderFace(builder, pos, sprite, Direction.DOWN, light, overlay, x1, x2, y1, y2, z1, z2, color);
        this.renderFace(builder, pos, sprite, Direction.UP, light, overlay, x1, x2, y1, y2, z1, z2, color);
        this.renderFace(builder, pos, sprite, Direction.NORTH, light, overlay, x1, x2, y1, y2, z1, z2, color);
        this.renderFace(builder, pos, sprite, Direction.SOUTH, light, overlay, x1, x2, y1, y2, z1, z2, color);
        this.renderFace(builder, pos, sprite, Direction.WEST, light, overlay, x1, x2, y1, y2, z1, z2, color);
        this.renderFace(builder, pos, sprite, Direction.EAST, light, overlay, x1, x2, y1, y2, z1, z2, color);
    }

    default public void renderFace(VertexConsumer builder, Matrix4f pos, TextureAtlasSprite sprite, Direction side, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {
        double px1 = x1 * 16.0f;
        double px2 = x2 * 16.0f;
        double py1 = y1 * 16.0f;
        double py2 = y2 * 16.0f;
        double pz1 = z1 * 16.0f;
        double pz2 = z2 * 16.0f;
        switch (side) {
            case DOWN: {
                float u1 = sprite.m_118367_(px1);
                float u2 = sprite.m_118367_(px2);
                float v1 = sprite.m_118393_(pz1);
                float v2 = sprite.m_118393_(pz2);
                builder.m_252986_(pos, x1, y1, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_252986_(pos, x1, y1, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_252986_(pos, x2, y1, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_252986_(pos, x2, y1, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                break;
            }
            case UP: {
                float u1 = sprite.m_118367_(px1);
                float u2 = sprite.m_118367_(px2);
                float v1 = sprite.m_118393_(pz1);
                float v2 = sprite.m_118393_(pz2);
                builder.m_252986_(pos, x1, y2, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(pos, x2, y2, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(pos, x2, y2, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(pos, x1, y2, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                break;
            }
            case NORTH: {
                float u1 = sprite.m_118367_(px1);
                float u2 = sprite.m_118367_(px2);
                float v1 = sprite.m_118393_(py1);
                float v2 = sprite.m_118393_(py2);
                builder.m_252986_(pos, x1, y1, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                builder.m_252986_(pos, x1, y2, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                builder.m_252986_(pos, x2, y2, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                builder.m_252986_(pos, x2, y1, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                break;
            }
            case SOUTH: {
                float u1 = sprite.m_118367_(px1);
                float u2 = sprite.m_118367_(px2);
                float v1 = sprite.m_118393_(py1);
                float v2 = sprite.m_118393_(py2);
                builder.m_252986_(pos, x2, y1, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_252986_(pos, x2, y2, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_252986_(pos, x1, y2, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                builder.m_252986_(pos, x1, y1, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                break;
            }
            case WEST: {
                float u1 = sprite.m_118367_(py1);
                float u2 = sprite.m_118367_(py2);
                float v1 = sprite.m_118393_(pz1);
                float v2 = sprite.m_118393_(pz2);
                builder.m_252986_(pos, x1, y1, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                builder.m_252986_(pos, x1, y2, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                builder.m_252986_(pos, x1, y2, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                builder.m_252986_(pos, x1, y1, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                break;
            }
            case EAST: {
                float u1 = sprite.m_118367_(py1);
                float u2 = sprite.m_118367_(py2);
                float v1 = sprite.m_118393_(pz1);
                float v2 = sprite.m_118393_(pz2);
                builder.m_252986_(pos, x2, y1, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v1).m_86008_(overlay).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                builder.m_252986_(pos, x2, y2, z1).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v1).m_86008_(overlay).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                builder.m_252986_(pos, x2, y2, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u2, v2).m_86008_(overlay).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                builder.m_252986_(pos, x2, y1, z2).m_6122_(color[1], color[2], color[3], color[0]).m_7421_(u1, v2).m_86008_(overlay).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            }
        }
    }
}

