/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.util;

import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TinkerableUtils {
    public static ITinkerable getTinkerable(ItemStack stack) {
        ITinkerable tinkerable;
        Item item = stack.m_41720_();
        return item instanceof ITinkerable ? (tinkerable = (ITinkerable)item) : null;
    }

    public static int getArmorSetMinimumTier(Player player) {
        int tier = -1;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = player.m_6844_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i));
            ITinkerable tinkerable = TinkerableUtils.getTinkerable(stack);
            if (tinkerable == null) {
                return -1;
            }
            int tinkerableTier = tinkerable.getTinkerableTier();
            if (tinkerableTier <= tier) continue;
            tier = tinkerableTier;
        }
        return tier;
    }

    public static boolean hasArmorSetMinimumTier(Player player, int tier) {
        return TinkerableUtils.getArmorSetMinimumTier(player) >= tier;
    }

    public static ChatFormatting getColorForTier(int tier) {
        return switch (tier) {
            case 1 -> CropTier.ONE.getTextColor();
            case 2 -> CropTier.TWO.getTextColor();
            case 3 -> CropTier.THREE.getTextColor();
            case 4 -> CropTier.FOUR.getTextColor();
            case 5 -> CropTier.FIVE.getTextColor();
            default -> ChatFormatting.GRAY;
        };
    }

    public static Component getTooltipForTier(int tier) {
        return Component.m_237113_((String)String.valueOf(tier)).m_130940_(TinkerableUtils.getColorForTier(tier));
    }
}

