/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.etf_properties;

import java.util.Optional;
import java.util.Properties;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.features.state.ETFEntityRenderState;
import traben.entity_texture_features.utils.ETFEntity;

public class VariantProperty
extends StringArrayOrRegexProperty {
    protected VariantProperty(String string) throws RandomProperty.RandomPropertyException {
        super(string);
    }

    public static VariantProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new VariantProperty(VariantProperty.readPropertiesOrThrow(properties, propertyNum, "variant", "variants"));
        }
        catch (RandomProperty.RandomPropertyException var3) {
            return null;
        }
    }

    @Override
    protected boolean shouldForceLowerCaseCheck() {
        return false;
    }

    @Override
    @Nullable
    public String getValueFromEntity(ETFEntityRenderState state) {
        if (state == null) {
            return null;
        }
        ETFEntity etfEntity = state.entity();
        if (etfEntity instanceof Entity) {
            if (etfEntity instanceof VariantHolder) {
                VariantHolder variableEntity = (VariantHolder)etfEntity;
                Object object = variableEntity.m_28554_();
                if (object instanceof StringRepresentable) {
                    StringRepresentable stringIdentifiable = (StringRepresentable)object;
                    return stringIdentifiable.m_7912_();
                }
                object = variableEntity.m_28554_();
                if (object instanceof CatVariant) {
                    CatVariant catVariant = (CatVariant)object;
                    return BuiltInRegistries.f_256754_.m_7854_((Object)catVariant).map(catVariantRegistryKey -> catVariantRegistryKey.m_135782_().m_135815_()).orElse(null);
                }
                object = variableEntity.m_28554_();
                if (object instanceof FrogVariant) {
                    FrogVariant frogVariant = (FrogVariant)object;
                    return BuiltInRegistries.f_256770_.m_7854_((Object)frogVariant).map(frogVariantRegistryKey -> frogVariantRegistryKey.m_135782_().m_135815_()).orElse(null);
                }
                object = variableEntity.m_28554_();
                if (object instanceof Holder) {
                    Holder registryEntry = (Holder)object;
                    return registryEntry.m_203543_().isPresent() ? ((ResourceKey)registryEntry.m_203543_().get()).m_135782_().m_135815_() : null;
                }
                object = variableEntity.m_28554_();
                if (object instanceof Optional) {
                    Object t;
                    Optional possibleStringIdentifiable = (Optional)object;
                    if (possibleStringIdentifiable.isPresent() && (t = possibleStringIdentifiable.get()) instanceof StringRepresentable) {
                        StringRepresentable stringIdentifiable = (StringRepresentable)t;
                        return stringIdentifiable.m_7912_();
                    }
                    return null;
                }
                object = variableEntity.m_28554_();
                if (object instanceof VillagerType) {
                    VillagerType villagerType = (VillagerType)object;
                    return villagerType.toString();
                }
                return variableEntity.m_28554_().toString();
            }
            return BuiltInRegistries.f_256780_.m_7854_((Object)((Entity)etfEntity).m_6095_()).map(key -> key.m_135782_().m_135815_()).orElse(null);
        }
        if (etfEntity instanceof BlockEntity) {
            BedBlockEntity bedBlockEntity;
            ShulkerBoxBlockEntity shulkerBoxBlockEntity;
            SignBlockEntity signBlockEntity;
            Block block;
            if (etfEntity instanceof SignBlockEntity && (block = (signBlockEntity = (SignBlockEntity)etfEntity).m_58900_().m_60734_()) instanceof SignBlock) {
                SignBlock abstractSignBlock = (SignBlock)block;
                return abstractSignBlock.m_56297_().f_61839_();
            }
            if (etfEntity instanceof ShulkerBoxBlockEntity && (block = (shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)etfEntity).m_58900_().m_60734_()) instanceof ShulkerBoxBlock) {
                ShulkerBoxBlock shulkerBoxBlock = (ShulkerBoxBlock)block;
                return String.valueOf(shulkerBoxBlock.m_56261_());
            }
            if (etfEntity instanceof BedBlockEntity && (block = (bedBlockEntity = (BedBlockEntity)etfEntity).m_58900_().m_60734_()) instanceof BedBlock) {
                BedBlock bedBlock = (BedBlock)block;
                return String.valueOf(bedBlock.m_49554_());
            }
            if (etfEntity instanceof DecoratedPotBlockEntity) {
                DecoratedPotBlockEntity pot = (DecoratedPotBlockEntity)etfEntity;
                DecoratedPotBlockEntity.Decorations sherds = pot.m_284296_();
                return (sherds.f_283886_().m_7968_() != ItemStack.f_41583_ ? sherds.f_283886_().m_5524_() : "none") + "," + (sherds.f_283809_().m_7968_() != ItemStack.f_41583_ ? sherds.f_283809_().m_5524_() : "none") + "," + (sherds.f_283873_().m_7968_() != ItemStack.f_41583_ ? sherds.f_283873_().m_5524_() : "none") + "," + (sherds.f_283810_().m_7968_() != ItemStack.f_41583_ ? sherds.f_283810_().m_5524_() : "none");
            }
            Object suffix = "";
            if (etfEntity instanceof SkullBlockEntity) {
                SkullBlockEntity skull = (SkullBlockEntity)etfEntity;
                suffix = "_direction_" + skull.m_58900_().m_61143_((Property)SkullBlock.f_56314_);
            }
            return (String)BuiltInRegistries.f_257049_.m_7854_((Object)((BlockEntity)etfEntity).m_58903_()).map(key -> key.m_135782_().m_135815_()).orElse(null) + (String)suffix;
        }
        return null;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"variant", "variants"};
    }
}

