/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.ritchiesprojectilelib;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rbasamoyai.ritchiesprojectilelib.chunkloading.ChunkManager;
import rbasamoyai.ritchiesprojectilelib.effects.screen_shake.ScreenShakeEffect;
import rbasamoyai.ritchiesprojectilelib.network.ClientboundShakeScreenPacket;
import rbasamoyai.ritchiesprojectilelib.network.RPLNetwork;

public class RitchiesProjectileLib {
    public static final String MOD_ID = "ritchiesprojectilelib";
    public static final String NAME = "Ritchie's Projectile Lib";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Ritchie's Projectile Lib");
    public static final String CHUNK_MANAGER_ID = "ritchiesprojectilelib_chunk_manager";

    public static void init() {
        RPLNetwork.init();
    }

    public static ResourceLocation resource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static void onPlayerJoin(ServerPlayer player) {
        RPLNetwork.onPlayerJoin(player);
    }

    private static ChunkManager getChunkManager(ServerLevel level) {
        return (ChunkManager)level.m_8895_().m_164861_(ChunkManager::load, ChunkManager::new, CHUNK_MANAGER_ID);
    }

    public static void onServerLevelTickEnd(ServerLevel level) {
        ChunkManager manager = RitchiesProjectileLib.getChunkManager(level);
        manager.tick(level);
    }

    public static void queueForceLoad(ServerLevel level, int chunkX, int chunkZ) {
        ChunkManager manager = RitchiesProjectileLib.getChunkManager(level);
        manager.queueForceLoad(new ChunkPos(chunkX, chunkZ));
    }

    public static void shakePlayerScreen(ServerPlayer player, ResourceLocation modHandlerId, ScreenShakeEffect effect) {
        RPLNetwork.sendToClientPlayer(new ClientboundShakeScreenPacket(modHandlerId, effect), player);
    }

    public static void shakePlayerScreen(ServerPlayer player, ScreenShakeEffect effect) {
        RPLNetwork.sendToClientPlayer(new ClientboundShakeScreenPacket(effect), player);
    }
}

