/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.audreys_additions.mixins;

import dev.jeryn.audreys_additions.CatVariantHolder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.registry.TRDimensionTypes;

@Mixin(value={GlobalConsoleBlockEntity.class})
public class GlobalConsoleBlockEntityMixin
implements CatVariantHolder {
    @Unique
    private ResourceLocation audreysAdditions$catVariantId = CatVariant.f_218150_.m_135782_();

    @Override
    @Unique
    public ResourceLocation getCatVariant() {
        return this.audreysAdditions$catVariantId;
    }

    @Override
    @Unique
    public void setCatVariant(ResourceLocation variant) {
        this.audreysAdditions$catVariantId = variant;
    }

    @Inject(method={"tick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lwhocraft/tardis_refined/common/blockentity/console/GlobalConsoleBlockEntity;)V"}, at={@At(value="HEAD")})
    public void tick(Level level, BlockPos pos, BlockState state, GlobalConsoleBlockEntity blockEntity, CallbackInfo ci) {
        if (level == null || blockEntity == null || blockEntity.pattern() == null || blockEntity.pattern().id() == null) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!"human_nature".equals(blockEntity.pattern().id().m_135815_())) {
            return;
        }
        if (!serverLevel.m_220362_().equals(TRDimensionTypes.TARDIS)) {
            return;
        }
        if (blockEntity.getTicksBooting() == 2) {
            if (blockEntity.m_58904_() instanceof ServerLevel) {
                Optional catVariant = BuiltInRegistries.f_256754_.m_213642_(blockEntity.m_58904_().m_213780_());
                if (blockEntity instanceof CatVariantHolder) {
                    CatVariantHolder catVariantHolder = (CatVariantHolder)blockEntity;
                    catVariant.ifPresent(catVariantReference -> catVariantHolder.setCatVariant(catVariantReference.m_205785_().m_135782_()));
                    blockEntity.sendUpdates();
                }
            }
            TardisLevelOperator.get((ServerLevel)serverLevel).ifPresent(operator -> {
                SoundEvent soundToPlay;
                TardisPilotingManager pilotingManager = operator.getPilotingManager();
                boolean isCrashing = pilotingManager.isCrashing();
                boolean isFlying = pilotingManager.isInFlight();
                if (serverLevel.f_46441_.m_188503_(400) != 0) {
                    return;
                }
                if (isCrashing) {
                    soundToPlay = SoundEvents.f_11789_;
                } else {
                    SoundEvent[] catIdleSounds = new SoundEvent[]{SoundEvents.f_11785_, SoundEvents.f_11786_, SoundEvents.f_11792_, SoundEvents.f_11793_};
                    soundToPlay = catIdleSounds[serverLevel.f_46441_.m_188503_(catIdleSounds.length)];
                }
                serverLevel.m_5594_(null, pos, soundToPlay, SoundSource.BLOCKS, 1.0f, 1.0f);
            });
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    private void onSaveAdditional(CompoundTag tag, CallbackInfo ci) {
        if (this.audreysAdditions$catVariantId != null) {
            tag.m_128359_("cat_variant", this.audreysAdditions$catVariantId.toString());
        }
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private void onLoad(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_("cat_variant")) {
            this.audreysAdditions$catVariantId = new ResourceLocation(tag.m_128461_("cat_variant"));
        }
    }
}

