/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.audreys_additions.forge.data;

import com.google.gson.JsonObject;
import dev.jeryn.audreys_additions.common.blocks.MonitorBlock;
import dev.jeryn.audreys_additions.common.blocks.SpecimenJarBlock;
import dev.jeryn.audreys_additions.common.registry.AudBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class AudBlocksModelProvider
extends BlockStateProvider {
    public AudBlocksModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "audreys_additions", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        for (Block value : ForgeRegistries.BLOCKS.getValues()) {
            ResourceLocation leftColumn;
            @Nullable ResourceLocation location = ForgeRegistries.BLOCKS.getKey((Object)value);
            if (!location.m_135827_().matches("audreys_additions")) continue;
            if (value == AudBlocks.LIGHTCOLUMN_RIGHT.get()) {
                leftColumn = new ResourceLocation("audreys_additions", "block/lightcolumn_right");
                this.threeDeeRotating(value, leftColumn);
                continue;
            }
            if (value == AudBlocks.LIGHTCOLUMN_LEFT.get()) {
                leftColumn = new ResourceLocation("audreys_additions", "block/lightcolumn_left");
                this.threeDeeRotating(value, leftColumn);
                continue;
            }
            if (value == AudBlocks.ARMCHAIR.get()) {
                ResourceLocation armChairModel = new ResourceLocation("audreys_additions", "block/armchair");
                this.threeDeeRotating(value, armChairModel);
                continue;
            }
            if (value == AudBlocks.KNOSSOS_THRONE.get()) {
                this.simpleBlockParticleOnly(value, new ResourceLocation("block/spruce_planks"));
                continue;
            }
            if (value == AudBlocks.FOLD_OUT_BED.get()) {
                this.simpleBlockParticleOnly(value, new ResourceLocation("block/black_wool"));
                continue;
            }
            if (value == AudBlocks.CEILING_CANOPY.get()) {
                this.simpleBlockParticleOnly(value, new ResourceLocation("block/quartz_pillar"));
                continue;
            }
            if (value == AudBlocks.ASTRAL_MAP.get()) {
                this.simpleBlockParticleOnly(value, new ResourceLocation("block/clay"));
                continue;
            }
            if (value == AudBlocks.FOOD_MACHINE.get()) {
                this.simpleBlockParticleOnly(value, new ResourceLocation("block/clay"));
                continue;
            }
            if (value instanceof MonitorBlock) {
                MonitorBlock monitorBlock = (MonitorBlock)value;
                ResourceLocation vicMon = new ResourceLocation("audreys_additions", "block/" + location.m_135815_());
                this.threeDeeRotating((Block)monitorBlock, vicMon);
                continue;
            }
            if (value instanceof SpecimenJarBlock) {
                SpecimenJarBlock specimenJarBlock = (SpecimenJarBlock)value;
                ResourceLocation specimenJarBlockModel = new ResourceLocation("block/red_stained_glass");
                this.simpleBlockParticleOnly(value, specimenJarBlockModel);
                continue;
            }
            this.simpleBlock(value);
        }
    }

    private void simpleBlockParticleOnly(Block block, ResourceLocation particleTexture) {
        @Nullable ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)block);
        ((BlockModelBuilder)this.models().getBuilder(key.toString())).texture("particle", particleTexture);
        this.getVariantBuilder(block).partialState().modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + key.m_135815_()))).addModel();
    }

    public JsonObject customLocation(Block block, ResourceLocation resourceLocation) {
        return ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().modelForState().modelFile((ModelFile)this.models().getExistingFile(resourceLocation)).addModel()).toJson();
    }

    public JsonObject threeDeeRotating(Block block, ResourceLocation location) {
        return this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.UncheckedModelFile(location)).rotationY((int)((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122435_()).build()).toJson();
    }
}

