/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.audreys_additions.common.blocks;

import dev.jeryn.audreys_additions.common.registry.AudBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.network.messages.screens.S2COpenMonitor;

public class MonitorBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED;
    protected static final VoxelShape AABB;
    protected static final VoxelShape BRACHACKI_MONITOR_NORTH;
    protected static final VoxelShape BRACHACKI_MONITOR_EAST;
    protected static final VoxelShape BRACHACKI_MONITOR_SOUTH;
    protected static final VoxelShape BRACHACKI_MONITOR_WEST;

    public MonitorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.375, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.4375, (double)0.1875, (double)0.125, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.75, (double)0.8125, (double)0.125, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.4375, (double)0.9375, (double)0.125, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static boolean isY(Direction dir) {
        return dir.m_122434_() == Direction.Axis.Y;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)super.m_5573_(blockPlaceContext).m_61124_((Property)f_54117_, (Comparable)blockPlaceContext.m_8125_());
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        if (blockState.m_60734_() == AudBlocks.BRACHACKI_MONITOR.get()) {
            Direction facing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
            return switch (facing) {
                case Direction.EAST -> BRACHACKI_MONITOR_WEST;
                case Direction.SOUTH -> BRACHACKI_MONITOR_NORTH;
                case Direction.WEST -> BRACHACKI_MONITOR_EAST;
                default -> BRACHACKI_MONITOR_SOUTH;
            };
        }
        return AABB;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        if (MonitorBlock.isY(from) || MonitorBlock.isY(to)) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TardisLevelOperator.get((ServerLevel)serverLevel).ifPresent(tardisLevelOperator -> new S2COpenMonitor(tardisLevelOperator.getInteriorManager().isWaitingToGenerate(), tardisLevelOperator.getPilotingManager().getCurrentLocation(), tardisLevelOperator.getPilotingManager().getTargetLocation(), tardisLevelOperator.getUpgradeHandler(), tardisLevelOperator.getAestheticHandler().getShellTheme()).send((ServerPlayer)player));
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, f_54117_});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    static {
        AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), (VoxelShape)Block.m_49796_((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0));
        BRACHACKI_MONITOR_NORTH = MonitorBlock.makeShape();
        BRACHACKI_MONITOR_EAST = MonitorBlock.rotateShape(Direction.NORTH, Direction.EAST, BRACHACKI_MONITOR_NORTH);
        BRACHACKI_MONITOR_SOUTH = MonitorBlock.rotateShape(Direction.NORTH, Direction.SOUTH, BRACHACKI_MONITOR_NORTH);
        BRACHACKI_MONITOR_WEST = MonitorBlock.rotateShape(Direction.NORTH, Direction.WEST, BRACHACKI_MONITOR_NORTH);
        WATERLOGGED = BlockStateProperties.f_61362_;
    }
}

