/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.audreys_additions.common.blocks;

import dev.jeryn.audreys_additions.common.blockentity.ChairBlockEntity;
import dev.jeryn.audreys_additions.common.blockentity.KnossosChairBlockEntity;
import dev.jeryn.audreys_additions.common.blocks.MonitorBlock;
import dev.jeryn.audreys_additions.common.registry.AudBlocks;
import dev.jeryn.audreys_additions.common.registry.AudEntities;
import dev.jeryn.audreys_additions.entity.ChairEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChairBaseBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    protected static final VoxelShape ARMCHAIR_NORTH = ChairBaseBlock.makeShape();
    protected static final VoxelShape ARMCHAIR_EAST = MonitorBlock.rotateShape(Direction.NORTH, Direction.EAST, ARMCHAIR_NORTH);
    protected static final VoxelShape ARMCHAIR_SOUTH = MonitorBlock.rotateShape(Direction.NORTH, Direction.SOUTH, ARMCHAIR_NORTH);
    protected static final VoxelShape ARMCHAIR_WEST = MonitorBlock.rotateShape(Direction.NORTH, Direction.WEST, ARMCHAIR_NORTH);

    public ChairBaseBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60955_());
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        if (blockState.m_60734_() == AudBlocks.ARMCHAIR.get()) {
            Direction facing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
            return switch (facing) {
                case Direction.EAST -> ARMCHAIR_NORTH;
                case Direction.SOUTH -> ARMCHAIR_EAST;
                case Direction.WEST -> ARMCHAIR_SOUTH;
                default -> ARMCHAIR_WEST;
            };
        }
        return super.m_5940_(blockState, blockGetter, blockPos, collisionContext);
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.875, (double)0.25, (double)0.875, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.875, (double)0.875, (double)0.8125, (double)0.9375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.875, (double)0.0, (double)0.8125, (double)0.9375, (double)0.125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.21875, (double)0.125, (double)0.0625, (double)0.78125, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.0, (double)0.875, (double)0.8125, (double)0.875, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.875, (double)0.0, (double)0.8125, (double)1.5, (double)0.125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.875, (double)0.875, (double)0.8125, (double)1.5, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)1.0, (double)0.125, (double)0.8125, (double)1.4375, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.875, (double)0.875, (double)0.8125, (double)1.5, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)1.0, (double)0.125, (double)0.8125, (double)1.4375, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.875, (double)0.0, (double)0.8125, (double)1.5, (double)0.125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.8125, (double)0.125, (double)0.8125, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.0, (double)0.0, (double)0.8125, (double)0.875, (double)0.125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.0, (double)0.25, (double)0.875, (double)0.125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.21875, (double)0.5, (double)0.03125, (double)0.78125, (double)0.625, (double)0.96875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && state.m_60734_() == AudBlocks.ARMCHAIR.get() && !player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof ChairBlockEntity) {
            ChairBlockEntity chairBlockEntity = (ChairBlockEntity)blockEntity;
            ItemStack coloredItemBlock = new ItemStack((ItemLike)AudBlocks.ARMCHAIR.get());
            coloredItemBlock.m_41764_(1);
            coloredItemBlock.m_41698_("display").m_128405_("color", chairBlockEntity.getColour());
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), coloredItemBlock);
            level.m_7967_((Entity)itemEntity);
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        KnossosChairBlockEntity knossosChairBlockEntity;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof KnossosChairBlockEntity && (knossosChairBlockEntity = (KnossosChairBlockEntity)blockEntity).getChairEntity() != null) {
            ChairEntity chairEntity = knossosChairBlockEntity.getChairEntity();
            chairEntity.m_20153_();
            chairEntity.m_142687_(Entity.RemovalReason.KILLED);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand != InteractionHand.MAIN_HAND) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof ChairBlockEntity)) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        ChairBlockEntity blockChair = (ChairBlockEntity)blockEntity;
        ItemStack heldItem = player.m_21120_(hand);
        Item item = heldItem.m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            DyeColor dyeColour = dyeItem.m_41089_();
            if (blockChair.getColour() != dyeColour.m_41071_()) {
                blockChair.setColour(dyeColour.m_41071_());
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
                level.m_7260_(pos, state, state, 3);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        ChairEntity chairEntity = blockChair.getChairEntity();
        if (chairEntity == null || !chairEntity.m_6084_()) {
            chairEntity = new ChairEntity((EntityType)AudEntities.CHAIR.get(), level);
            chairEntity.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, player.m_146908_(), 0.0f);
            blockChair.setChairEntity(chairEntity);
            level.m_7967_((Entity)chairEntity);
        }
        if (!chairEntity.m_20363_((Entity)player)) {
            player.m_20329_((Entity)chairEntity);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)f_54117_, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)f_54117_)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)f_54117_)));
    }

    public BlockState m_5573_(BlockPlaceContext arg) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)arg.m_8125_());
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ChairBlockEntity(pos, state);
    }
}

