/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.audreys_additions.common.blockentity;

import dev.jeryn.audreys_additions.AudTags;
import dev.jeryn.audreys_additions.common.registry.AudBlockEntities;
import dev.jeryn.audreys_additions.common.registry.AudItems;
import dev.jeryn.audreys_additions.common.registry.AudSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FoodMachineBlockEntity
extends BlockEntity
implements BlockEntityTicker<FoodMachineBlockEntity> {
    public final AnimationState POWER = new AnimationState();
    public final AnimationState FLASHING = new AnimationState();
    private int fuelLevel = 0;
    private static final int MAX_FUEL = 100;
    private int productionTimer = 0;
    private boolean isProducing = false;

    public FoodMachineBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)AudBlockEntities.FOOD_MACHINE.get(), blockPos, blockState);
    }

    public boolean isProducing() {
        return this.isProducing;
    }

    public void setProducing(boolean producing) {
        this.isProducing = producing;
        this.sendUpdates();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void sendUpdates() {
        if (this.f_58857_ != null && this.m_58900_() != null && this.m_58900_().m_60734_() != null) {
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
        this.m_6596_();
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("FuelLevel", this.fuelLevel);
        tag.m_128405_("ProductionTimer", this.productionTimer);
        tag.m_128379_("IsProducing", this.isProducing);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fuelLevel = tag.m_128451_("FuelLevel");
        this.productionTimer = tag.m_128451_("ProductionTimer");
        this.isProducing = tag.m_128471_("IsProducing");
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, FoodMachineBlockEntity blockEntity) {
        if (!level.f_46443_) {
            if (this.fuelLevel > 0 && this.isProducing) {
                this.startProducing(level, blockPos);
            }
            return;
        }
        if (this.isProducing) {
            if (!this.FLASHING.m_216984_()) {
                this.FLASHING.m_216977_((int)level.m_46467_());
            }
        } else {
            this.FLASHING.m_216973_();
        }
    }

    public void startProducing(Level level, BlockPos blockPos) {
        if (this.fuelLevel > 0 && this.isProducing) {
            ++this.productionTimer;
            this.sendUpdates();
            if (this.productionTimer == 1) {
                level.m_6263_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (SoundEvent)AudSounds.FOOD_MACHINE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (this.productionTimer >= 180) {
                ItemStack output = new ItemStack((ItemLike)AudItems.FOOD_CUBE.get());
                Block.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)output);
                this.productionTimer = 0;
                this.isProducing = false;
                this.fuelLevel -= 5;
                this.sendUpdates();
            }
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean addFuel(ItemStack fuelItem) {
        if (fuelItem.m_204117_(AudTags.FUEL_ITEMS)) {
            int fuelValue = 5;
            int spaceLeft = 100 - this.fuelLevel;
            if (spaceLeft > 0) {
                int fuelToAdd = Math.min(fuelValue, spaceLeft);
                this.fuelLevel += fuelToAdd;
                this.sendUpdates();
                Level level = this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    BlockPos blockPos = this.m_58899_();
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)blockPos.m_123341_() + 0.5, (double)(blockPos.m_123342_() + 1), (double)blockPos.m_123343_() + 0.5, 5, 0.2, 0.2, 0.2, 0.02);
                }
                float pitch = 0.5f + (float)this.fuelLevel / 100.0f * 1.5f;
                pitch = Math.min(pitch, 2.0f);
                this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (SoundEvent)SoundEvents.f_12170_.m_203334_(), SoundSource.BLOCKS, 1.0f, pitch);
                fuelItem.m_41774_(1);
                return true;
            }
        }
        return false;
    }

    public int getFuelLevel() {
        return this.fuelLevel;
    }
}

