/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.audreys_additions.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.jeryn.audreys_additions.AUDModelRegistry;
import dev.jeryn.audreys_additions.client.models.furniture.SpecimenJarModel;
import dev.jeryn.audreys_additions.common.blockentity.SpecimenJarBlockEntity;
import dev.jeryn.audreys_additions.common.registry.AudBlocks;
import dev.jeryn.frame.tardis.Frame;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderSpecimenJar
implements BlockEntityRenderer<SpecimenJarBlockEntity>,
BlockEntityRendererProvider<SpecimenJarBlockEntity> {
    private final Map<Block, RenderData> renderMap = new HashMap<Block, RenderData>();

    public RenderSpecimenJar(BlockEntityRendererProvider.Context context) {
        this.register(context, (Block)AudBlocks.SPECIMEN_JAR_ALLAY.get(), AUDModelRegistry.SPECIMEN_JAR_ALLAY, "specimen_jar_allay");
        this.register(context, (Block)AudBlocks.SPECIMEN_JAR_CREEPER.get(), AUDModelRegistry.SPECIMEN_JAR_CREEPER, "specimen_jar_creeper");
        this.register(context, (Block)AudBlocks.SPECIMEN_JAR_DRAGON.get(), AUDModelRegistry.SPECIMEN_JAR_DRAGON, "specimen_jar_dragon");
        this.register(context, (Block)AudBlocks.SPECIMEN_JAR_PIGLIN.get(), AUDModelRegistry.SPECIMEN_JAR_PIGLIN, "specimen_jar_piglin");
        this.register(context, (Block)AudBlocks.SPECIMEN_JAR_SKELETON.get(), AUDModelRegistry.SPECIMEN_JAR_SKELETON, "specimen_jar_skeleton");
        this.register(context, (Block)AudBlocks.SPECIMEN_JAR_VEX.get(), AUDModelRegistry.SPECIMEN_JAR_VEX, "specimen_jar_vex");
        this.register(context, (Block)AudBlocks.SPECIMEN_JAR_WITHERSKELETON.get(), AUDModelRegistry.SPECIMEN_JAR_WITHERSKELETON, "specimen_jar_wither_skeleton");
        this.register(context, (Block)AudBlocks.SPECIMEN_JAR_ZOMBIE.get(), AUDModelRegistry.SPECIMEN_JAR_ZOMBIE, "specimen_jar_zombie");
        this.register(context, (Block)AudBlocks.SPECIMEN_JAR.get(), AUDModelRegistry.SPECIMEN_JAR, "specimen_jar");
    }

    private void register(BlockEntityRendererProvider.Context context, Block block, ModelLayerLocation modelLayer, String name) {
        ResourceLocation texture = new ResourceLocation("audreys_additions", "textures/blockentity/specimen_jar/" + name + ".png");
        ResourceLocation animation = new ResourceLocation("audreys_additions", "frame/specimen_jar/" + name + ".json");
        this.renderMap.put(block, new RenderData(new SpecimenJarModel(context.m_173582_(modelLayer)).setAnimation(Frame.loadAnimation((ResourceLocation)animation)), texture));
    }

    public void render(SpecimenJarBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState state = blockEntity.m_58900_();
        RenderData renderData = this.renderMap.get(state.m_60734_());
        if (renderData == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(((Integer)state.m_61143_((Property)BlockStateProperties.f_61390_)).floatValue() * 22.5f));
        renderData.model.renderToBuffer(blockEntity, poseStack, bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)renderData.texture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public BlockEntityRenderer<SpecimenJarBlockEntity> m_173570_(BlockEntityRendererProvider.Context context) {
        return new RenderSpecimenJar(context);
    }

    private record RenderData(SpecimenJarModel model, ResourceLocation texture) {
    }
}

