/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.audreys_additions.client.models.shell;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.jeryn.audreys_additions.client.models.shell.PoliceBoxModel;
import dev.jeryn.frame.tardis.Frame;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.common.blockentity.shell.GlobalShellBlockEntity;

public class TrakenClockModel
extends PoliceBoxModel {
    public static final AnimationDefinition FREE_SPIN = Frame.loadAnimation((ResourceLocation)new ResourceLocation("audreys_additions", "frame/shell/free_spin.json"));
    private final ModelPart big_hand = Frame.findPart((HierarchicalModel)this, (String)"big_hand");
    private final ModelPart small_hand = Frame.findPart((HierarchicalModel)this, (String)"small_hand");
    private final ModelPart right_door = Frame.findPart((HierarchicalModel)this, (String)"right_door");

    public TrakenClockModel(ModelPart root) {
        super(root, (entity, open, isBaseModel, poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha) -> {});
    }

    @Override
    public void setDoorPosition(boolean open) {
        this.right_door.f_104204_ = open ? (float)Math.toRadians(-110.0) : 0.0f;
    }

    public void handleSpecialAnimation(GlobalShellBlockEntity entity, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float baseAlpha) {
        poseStack.m_85836_();
        if (entity.getTardisId() == null) {
            poseStack.m_85849_();
            return;
        }
        TardisClientData tardisClientData = TardisClientData.getInstance((ResourceKey)entity.getTardisId());
        boolean isInFlight = tardisClientData.isFlying();
        float bigHandAngle = 0.0f;
        float smallHandAngle = 0.0f;
        if (isInFlight) {
            this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
            this.m_233385_(tardisClientData.ROTOR_ANIMATION, FREE_SPIN, Minecraft.m_91087_().f_91074_.f_19797_, 1.0f);
        } else {
            Calendar calendar = Calendar.getInstance();
            int hour = calendar.get(10) % 12;
            int minute = calendar.get(12);
            double hourHandDegree = ((double)hour + (double)minute / 60.0) / 12.0 * 360.0;
            double minuteHandDegree = (double)minute / 60.0 * 360.0;
            smallHandAngle = (float)Math.toRadians(hourHandDegree);
            bigHandAngle = (float)Math.toRadians(minuteHandDegree);
            this.small_hand.f_104203_ = 0.0f;
            this.small_hand.f_104204_ = 0.0f;
            this.small_hand.f_104205_ = smallHandAngle;
            this.big_hand.f_104203_ = 0.0f;
            this.big_hand.f_104204_ = 0.0f;
            this.big_hand.f_104205_ = bigHandAngle;
        }
        this.setDoorPosition(entity.isOpen());
        poseStack.m_85849_();
    }
}

