/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.audreys_additions.client.models.shell;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.jeryn.audreys_additions.client.models.shell.TrakenClockModel;
import dev.jeryn.frame.tardis.Frame;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceKey;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.model.blockentity.door.interior.SingleInteriorDoorModel;
import whocraft.tardis_refined.common.blockentity.door.GlobalDoorBlockEntity;

public class TrakenClockInteriorDoorModel
extends SingleInteriorDoorModel {
    private final ModelPart portal = Frame.findPart((HierarchicalModel)this, (String)"portal");
    private final ModelPart small_hand = Frame.findPart((HierarchicalModel)this, (String)"small_hand");
    private final ModelPart big_hand = Frame.findPart((HierarchicalModel)this, (String)"big_hand");

    public TrakenClockInteriorDoorModel(ModelPart root, float openAmount) {
        super(root, openAmount);
    }

    public void renderFrame(GlobalDoorBlockEntity doorBlockEntity, boolean open, boolean isBaseModel, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.setDoorPosition(open);
        this.m_142109_().m_171331_().forEach(modelPart -> {
            modelPart.f_104207_ = true;
        });
        this.portal.f_104207_ = false;
        TardisClientData tardisClientData = TardisClientData.getInstance((ResourceKey)doorBlockEntity.m_58904_().m_46472_());
        boolean isInFlight = tardisClientData.isFlying();
        float bigHandAngle = 0.0f;
        float smallHandAngle = 0.0f;
        if (isInFlight) {
            this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
            this.setDoorPosition(open);
            this.m_233385_(tardisClientData.ROTOR_ANIMATION, TrakenClockModel.FREE_SPIN, Minecraft.m_91087_().f_91074_.f_19797_, 1.0f);
        } else {
            Calendar calendar = Calendar.getInstance();
            int hour = calendar.get(10) % 12;
            int minute = calendar.get(12);
            double hourHandDegree = ((double)hour + (double)minute / 60.0) / 12.0 * 360.0;
            double minuteHandDegree = (double)minute / 60.0 * 360.0;
            smallHandAngle = (float)Math.toRadians(hourHandDegree);
            bigHandAngle = (float)Math.toRadians(minuteHandDegree);
            this.small_hand.f_104203_ = 0.0f;
            this.small_hand.f_104204_ = 0.0f;
            this.small_hand.f_104205_ = smallHandAngle;
            this.big_hand.f_104203_ = 0.0f;
            this.big_hand.f_104204_ = 0.0f;
            this.big_hand.f_104205_ = bigHandAngle;
        }
        this.m_142109_().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

