/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.audreys_additions.client.models.furniture;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.jeryn.audreys_additions.client.renderers.Animatable;
import dev.jeryn.audreys_additions.common.blockentity.FoodMachineBlockEntity;
import dev.jeryn.frame.tardis.Frame;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.client.model.GenericModel;

public class FoodMachineModel
extends GenericModel
implements Animatable<FoodMachineBlockEntity> {
    public static final AnimationDefinition FLASHING = Frame.loadAnimation((ResourceLocation)new ResourceLocation("audreys_additions", "frame/food_machine/flashing.json"));
    private final List<ModelPart> lights = new ArrayList<ModelPart>();

    public FoodMachineModel(ModelPart root) {
        super(root);
        for (int i = 1; i <= 18; ++i) {
            this.lights.add(Frame.findPart((HierarchicalModel)this, (String)("Light" + i)));
        }
    }

    @Override
    public void renderToBuffer(FoodMachineBlockEntity blockentity, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.updateLights(blockentity);
        if (blockentity.isProducing()) {
            this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
            this.m_233381_(blockentity.FLASHING, FLASHING, blockentity.m_58904_().m_46467_());
        }
        this.m_142109_().m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void updateLights(FoodMachineBlockEntity blockentity) {
        int fuelLevel = blockentity.getFuelLevel();
        double step = 100.0 / (double)this.lights.size();
        for (int i = 0; i < this.lights.size(); ++i) {
            double threshold;
            this.setLightRotation(this.lights.get(i), (double)fuelLevel >= (threshold = (double)(i + 1) * step) ? (int)Math.toRadians(180.0) : 0);
        }
    }

    private void setLightRotation(ModelPart light, int rotation) {
        if (light != null) {
            light.f_104203_ = rotation;
        }
    }
}

