/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.audreys_additions.client.models.console;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.jeryn.frame.tardis.Frame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import whocraft.tardis_refined.TRConfig;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.model.blockentity.console.ConsoleUnit;
import whocraft.tardis_refined.common.block.console.GlobalConsoleBlock;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;

public class PertweeConsoleModel
extends HierarchicalModel
implements ConsoleUnit {
    public static final AnimationDefinition IDLE = Frame.loadAnimation((ResourceLocation)new ResourceLocation("audreys_additions", "frame/console/pertwee/idle.json"));
    public static final AnimationDefinition FLIGHT = Frame.loadAnimation((ResourceLocation)new ResourceLocation("audreys_additions", "frame/console/pertwee/flight.json"));
    public static final AnimationDefinition CRASH = Frame.loadAnimation((ResourceLocation)new ResourceLocation("audreys_additions", "frame/console/pertwee/crash.json"));
    public static final AnimationDefinition POWER_ON = Frame.loadAnimation((ResourceLocation)new ResourceLocation("audreys_additions", "frame/console/pertwee/power_on.json"));
    public static final AnimationDefinition POWER_OFF = Frame.loadAnimation((ResourceLocation)new ResourceLocation("audreys_additions", "frame/console/pertwee/power_off.json"));
    private final ModelPart root;
    private final ModelPart throttle_1;
    private final ModelPart throttle_2;
    private final ModelPart throttle_3;
    private final ModelPart incrementSwitch;

    public PertweeConsoleModel(ModelPart root) {
        this.root = root;
        this.throttle_1 = Frame.findPart((HierarchicalModel)this, (String)"ThrottleSwitch1");
        this.throttle_2 = Frame.findPart((HierarchicalModel)this, (String)"ThrottleSwitch2");
        this.throttle_3 = Frame.findPart((HierarchicalModel)this, (String)"ThrottleSwitch3");
        this.incrementSwitch = Frame.findPart((HierarchicalModel)this, (String)"MainLever1");
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_142109_().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderConsole(GlobalConsoleBlockEntity globalConsoleBlock, Level level, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        boolean powered = globalConsoleBlock == null || (Boolean)globalConsoleBlock.m_58900_().m_61143_((Property)GlobalConsoleBlock.POWERED) != false;
        int tickCount = Minecraft.m_91087_().f_91074_.f_19797_;
        TardisClientData reactions = TardisClientData.getInstance((ResourceKey)level.m_46472_());
        if (globalConsoleBlock != null) {
            if (powered) {
                if (globalConsoleBlock.getTicksBooting() > 0) {
                    globalConsoleBlock.powerOff.m_216973_();
                    globalConsoleBlock.powerOn.m_216982_(tickCount);
                    this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                    this.m_233381_(globalConsoleBlock.powerOn, POWER_ON, tickCount);
                } else {
                    globalConsoleBlock.powerOff.m_216973_();
                }
                if (reactions.isFlying()) {
                    this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                    this.m_233381_(reactions.ROTOR_ANIMATION, FLIGHT, tickCount);
                } else if (reactions.isCrashing()) {
                    this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                    this.m_233381_(reactions.CRASHING_ANIMATION, CRASH, tickCount);
                } else if (((Boolean)TRConfig.CLIENT.PLAY_CONSOLE_IDLE_ANIMATIONS.get()).booleanValue() && globalConsoleBlock.getTicksBooting() == 0) {
                    this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                    this.m_233381_(globalConsoleBlock.liveliness, IDLE, tickCount);
                }
            } else {
                if (!globalConsoleBlock.powerOff.m_216984_()) {
                    globalConsoleBlock.powerOn.m_216973_();
                    globalConsoleBlock.powerOff.m_216977_(tickCount);
                }
                this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                this.m_233381_(globalConsoleBlock.powerOff, POWER_OFF, tickCount);
            }
        }
        this.m_142109_().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ResourceLocation getDefaultTexture() {
        return new ResourceLocation("audreys_additions", "textures/blockentity/console/pertwee/pertwee.png");
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_6973_(Entity entity, float f, float g, float h, float i, float j) {
    }
}

