/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.audreys_additions.client.models.console;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.jeryn.audreys_additions.AUDModelRegistry;
import dev.jeryn.audreys_additions.CatVariantHolder;
import dev.jeryn.frame.tardis.Frame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import whocraft.tardis_refined.TRConfig;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.model.blockentity.console.ConsoleUnit;
import whocraft.tardis_refined.common.block.console.GlobalConsoleBlock;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;

public class HumanNatureConsoleModel
extends HierarchicalModel
implements ConsoleUnit {
    public static final AnimationDefinition IDLE = Frame.loadAnimation((ResourceLocation)new ResourceLocation("audreys_additions", "frame/console/human_nature/idle.json"));
    public static final AnimationDefinition FLIGHT = Frame.loadAnimation((ResourceLocation)new ResourceLocation("audreys_additions", "frame/console/human_nature/flight.json"));
    public static final AnimationDefinition CRASH = Frame.loadAnimation((ResourceLocation)new ResourceLocation("audreys_additions", "frame/console/human_nature/crash.json"));
    public static final AnimationDefinition POWER_ON = Frame.loadAnimation((ResourceLocation)new ResourceLocation("audreys_additions", "frame/console/human_nature/power_on.json"));
    public static final AnimationDefinition POWER_OFF = Frame.loadAnimation((ResourceLocation)new ResourceLocation("audreys_additions", "frame/console/human_nature/power_off.json"));
    private final ModelPart root;

    public HumanNatureConsoleModel(ModelPart root) {
        this.root = root;
    }

    public static void renderConsoleCat(GlobalConsoleBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        CatVariant catVariant;
        if (blockEntity == null || AUDModelRegistry.cat == null || !blockEntity.theme().m_135815_().contains("human_nature") || blockEntity.pattern().id().m_135815_().contains("no_cat")) {
            return;
        }
        ResourceLocation catLocation = ((CatVariantHolder)blockEntity).getCatVariant();
        if (catLocation == null || !BuiltInRegistries.f_256754_.m_7804_(catLocation)) {
            catLocation = CatVariant.f_218150_.m_135782_();
        }
        if ((catVariant = (CatVariant)BuiltInRegistries.f_256754_.m_7745_(catLocation)) == null) {
            return;
        }
        poseStack.m_85836_();
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource isolatedBuffer = mc.m_91269_().m_110104_();
        RenderType renderType = RenderType.m_110458_((ResourceLocation)catVariant.f_218151_());
        AUDModelRegistry.cat.renderCat(blockEntity, blockEntity.m_58904_(), poseStack, isolatedBuffer.m_6299_(renderType), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        isolatedBuffer.m_109912_(renderType);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_142109_().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderConsole(GlobalConsoleBlockEntity globalConsoleBlock, Level level, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        boolean powered = globalConsoleBlock == null || (Boolean)globalConsoleBlock.m_58900_().m_61143_((Property)GlobalConsoleBlock.POWERED) != false;
        int tickCount = Minecraft.m_91087_().f_91074_.f_19797_;
        TardisClientData reactions = TardisClientData.getInstance((ResourceKey)level.m_46472_());
        if (globalConsoleBlock != null) {
            if (powered) {
                if (globalConsoleBlock.getTicksBooting() > 0) {
                    globalConsoleBlock.powerOff.m_216973_();
                    globalConsoleBlock.powerOn.m_216982_(tickCount);
                    this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                    this.m_233381_(globalConsoleBlock.powerOn, POWER_ON, tickCount);
                } else {
                    globalConsoleBlock.powerOff.m_216973_();
                }
                if (reactions.isFlying()) {
                    this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                    this.m_233381_(reactions.ROTOR_ANIMATION, FLIGHT, tickCount);
                } else if (reactions.isCrashing()) {
                    this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                    this.m_233381_(reactions.CRASHING_ANIMATION, CRASH, tickCount);
                } else if (((Boolean)TRConfig.CLIENT.PLAY_CONSOLE_IDLE_ANIMATIONS.get()).booleanValue() && globalConsoleBlock.getTicksBooting() == 0) {
                    this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                    this.m_233381_(globalConsoleBlock.liveliness, IDLE, tickCount);
                }
            } else {
                if (!globalConsoleBlock.powerOff.m_216984_()) {
                    globalConsoleBlock.powerOn.m_216973_();
                    globalConsoleBlock.powerOff.m_216977_(tickCount);
                }
                this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                this.m_233381_(globalConsoleBlock.powerOff, POWER_OFF, tickCount);
            }
        }
        this.m_142109_().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        HumanNatureConsoleModel.renderConsoleCat(globalConsoleBlock, poseStack, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0xF000F0, packedOverlay);
    }

    public ResourceLocation getDefaultTexture() {
        return new ResourceLocation("audreys_additions", "textures/blockentity/console/human_nature/human_nature.png");
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_6973_(Entity entity, float f, float g, float h, float i, float j) {
    }
}

