/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.caverns_and_chasms.core.registry.CCSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TetherPotionItem
extends PotionItem
implements Equipable {
    public TetherPotionItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return this.m_269277_((Item)this, level, player, hand);
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public EquipmentSlot m_40402_() {
        return this.getEquipmentSlot(new ItemStack((ItemLike)this));
    }

    @Nullable
    public SoundEvent m_150681_() {
        return (SoundEvent)CCSoundEvents.TETHER_POTION_EQUIP.get();
    }

    public Component m_7626_(ItemStack stack) {
        Component component = super.m_7626_(stack);
        if (component.toString().contains("item.")) {
            MutableComponent intro = Component.m_237115_((String)(this.m_5524_() + ".null"));
            ItemStack regularPotion = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)PotionUtils.m_43577_((CompoundTag)stack.m_41783_()));
            String newComponent = regularPotion.m_41778_();
            return intro.m_7220_((Component)Component.m_237115_((String)newComponent));
        }
        return component;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        List list = PotionUtils.m_43547_((ItemStack)stack);
        ArrayList list1 = Lists.newArrayList();
        ArrayList instanttooltip = Lists.newArrayList();
        ArrayList continuoustooltip = Lists.newArrayList();
        if (list.isEmpty()) {
            continuoustooltip.add(Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        } else {
            for (MobEffectInstance mobeffectinstance : list) {
                MutableComponent mutablecomponent = Component.m_237115_((String)mobeffectinstance.m_19576_());
                MobEffect effect = mobeffectinstance.m_19544_();
                Map map = effect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), effect.m_7048_(mobeffectinstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                    }
                }
                if (mobeffectinstance.m_19564_() > 0) {
                    mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + mobeffectinstance.m_19564_()))});
                }
                if (effect.m_8093_()) {
                    instanttooltip.add(mutablecomponent.m_130940_(effect.m_19483_().m_19497_()));
                    continue;
                }
                mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, StringUtil.m_14404_((int)TetherPotionItem.getTetherPotionDuration(mobeffectinstance.m_19557_()))});
                continuoustooltip.add(mutablecomponent.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
        tooltip.addAll(instanttooltip);
        if (!continuoustooltip.isEmpty()) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)("item.modifiers." + EquipmentSlot.HEAD.m_20751_())).m_130940_(ChatFormatting.GRAY));
            tooltip.addAll(continuoustooltip);
        }
        if (!list1.isEmpty()) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.m_22218_();
                double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public static int getTetherPotionDuration(int originalDuration) {
        int duration = Math.round(10.0f - 1.0f / (((float)originalDuration / 20.0f + 200.0f) * 5.0E-4f)) * 20;
        return Math.max(duration, 20);
    }

    public static void updateTetherPotionEffects(LivingEntity entity, ItemStack stack, boolean infiniteDuration) {
        for (MobEffectInstance instance : PotionUtils.m_43547_((ItemStack)stack)) {
            if (instance.m_19544_().m_8093_()) continue;
            int i = infiniteDuration ? -1 : TetherPotionItem.getTetherPotionDuration(instance.m_19557_());
            MobEffectInstance currentinstance = entity.m_21124_(instance.m_19544_());
            MobEffectInstance newinstance = new MobEffectInstance(instance.m_19544_(), i, instance.m_19564_(), instance.m_19571_(), instance.m_19572_(), instance.m_19575_());
            if (currentinstance == null || currentinstance.m_19564_() < instance.m_19564_()) {
                entity.m_7292_(newinstance);
                continue;
            }
            if (currentinstance.m_19564_() != instance.m_19564_()) continue;
            entity.m_21221_().put(instance.m_19544_(), newinstance);
            if (!(entity instanceof ServerPlayer)) continue;
            ((ServerPlayer)entity).f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(entity.m_19879_(), newinstance));
        }
    }
}

