/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.client.model;

import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.caverns_and_chasms.common.entity.monster.Peeper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public class PeeperModel<T extends Peeper>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart pupil;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;

    public PeeperModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.pupil = this.head.m_171324_("pupil");
        this.rightHindLeg = root.m_171324_("right_hind_leg");
        this.leftHindLeg = root.m_171324_("left_hind_leg");
        this.rightFrontLeg = root.m_171324_("right_front_leg");
        this.leftFrontLeg = root.m_171324_("left_front_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        CubeDeformation extrudes = new CubeDeformation(0.25f);
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -12.0f, -7.99f, 10.0f, 10.0f, 10.0f, deformation).m_171514_(40, 0).m_171488_(-5.0f, -12.0f, -7.99f, 10.0f, 10.0f, 10.0f, extrudes), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        head.m_171599_("pupil", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, deformation), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)-8.0f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, -24.0f, -2.0f, 8.0f, 17.0f, 4.0f, deformation).m_171514_(40, 20).m_171488_(-4.0f, -24.0f, -2.0f, 8.0f, 17.0f, 4.0f, extrudes), PartPose.m_171419_((float)0.0f, (float)22.0f, (float)0.0f));
        root.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(48, 41).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 9.0f, 4.0f, deformation).m_171514_(112, 41).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 9.0f, 4.0f, extrudes), PartPose.m_171419_((float)-2.0f, (float)16.0f, (float)4.0f));
        root.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(32, 41).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 9.0f, 4.0f, deformation), PartPose.m_171419_((float)2.0f, (float)16.0f, (float)4.0f));
        root.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 41).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 9.0f, 4.0f, deformation), PartPose.m_171419_((float)-2.0f, (float)16.0f, (float)-4.0f));
        root.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(16, 41).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 9.0f, 4.0f, deformation).m_171514_(80, 41).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 9.0f, 4.0f, extrudes), PartPose.m_171419_((float)2.0f, (float)16.0f, (float)-4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(T peeper, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        Entity target = Minecraft.m_91087_().m_91288_();
        if (peeper.m_5448_() != null) {
            target = peeper.m_5448_();
        }
        if (target != null) {
            this.pupil.f_233553_ = 1.0f;
            this.pupil.f_233554_ = 1.0f;
            float scale = Math.min(1.5f, 2.0f / peeper.m_20270_(target));
            this.pupil.f_233553_ += scale;
            this.pupil.f_233554_ += scale;
            RandomSource random = peeper.m_217043_();
            this.pupil.f_104200_ = 0.0f;
            this.pupil.f_104201_ = -7.0f;
            if (peeper.m_20270_(target) <= 3.0f) {
                this.pupil.f_104200_ += (float)MathUtil.makeNegativeRandomly((double)(random.m_188501_() * 0.25f), (RandomSource)random);
                this.pupil.f_104201_ += (float)MathUtil.makeNegativeRandomly((double)(random.m_188501_() * 0.25f), (RandomSource)random);
            }
        }
        this.pupil.f_104207_ = true;
    }
}

