/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.okzoomer.config;

import com.matyrobbrt.okzoomer.config.ConfigEnums;
import com.matyrobbrt.okzoomer.network.OkZoomerNetwork;
import com.matyrobbrt.okzoomer.utils.ZoomUtils;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class ClientConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.EnumValue<ConfigEnums.CinematicCameraOptions> CINEMATIC_CAMERA;
    public static final ForgeConfigSpec.EnumValue<ConfigEnums.ZoomTransitionOptions> ZOOM_TRANSITION;
    public static final ForgeConfigSpec.EnumValue<ConfigEnums.ZoomModes> ZOOM_MODE;
    public static final ForgeConfigSpec.EnumValue<ConfigEnums.ZoomOverlays> ZOOM_OVERLAY;
    public static final ForgeConfigSpec.EnumValue<ConfigEnums.SpyglassDependency> SPYGLASS_DEPENDENCY;
    public static final ForgeConfigSpec.BooleanValue REDUCE_SENSITIVITY;
    public static final ForgeConfigSpec.BooleanValue ALLOW_SCROLLING;
    public static final ForgeConfigSpec.BooleanValue EXTRA_KEY_BINDS;
    public static final ForgeConfigSpec.BooleanValue DISABLE_OVERLAY_NO_HUD;
    public static final ForgeConfigSpec.DoubleValue ZOOM_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue MINIMUM_ZOOM_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue MAXIMUM_ZOOM_DIVISOR;
    public static final ForgeConfigSpec.IntValue UPPER_SCROLL_STEPS;
    public static final ForgeConfigSpec.IntValue LOWER_SCROLL_STEPS;
    public static final ForgeConfigSpec.DoubleValue SMOOTH_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue CINEMATIC_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue MINIMUM_LINEAR_STEP;
    public static final ForgeConfigSpec.DoubleValue MAXIMUM_LINEAR_STEP;
    public static final ForgeConfigSpec.BooleanValue RESET_ZOOM_WITH_MOUSE;
    public static final ForgeConfigSpec.BooleanValue USE_SPYGLASS_TEXTURE;
    public static final ForgeConfigSpec.BooleanValue USE_SPYGLASS_SOUNDS;
    public static final ForgeConfigSpec.BooleanValue SHOW_RESTRICTION_TOASTS;

    public static void resetToPreset(ZoomPresets preset) {
        CINEMATIC_CAMERA.set((Object)(preset == ZoomPresets.CLASSIC ? ConfigEnums.CinematicCameraOptions.VANILLA : ConfigEnums.CinematicCameraOptions.OFF));
        REDUCE_SENSITIVITY.set((Object)(preset != ZoomPresets.CLASSIC ? 1 : 0));
        ZOOM_TRANSITION.set((Object)(preset == ZoomPresets.CLASSIC ? ConfigEnums.ZoomTransitionOptions.OFF : ConfigEnums.ZoomTransitionOptions.SMOOTH));
        ZOOM_MODE.set((Object)(preset == ZoomPresets.PERSISTENT ? ConfigEnums.ZoomModes.PERSISTENT : ConfigEnums.ZoomModes.HOLD));
        ALLOW_SCROLLING.set((Object)(preset == ZoomPresets.CLASSIC || preset == ZoomPresets.SPYGLASS ? 1 : 0));
        EXTRA_KEY_BINDS.set((Object)(preset != ZoomPresets.CLASSIC ? 1 : 0));
        ZOOM_OVERLAY.set((Object)(preset == ZoomPresets.SPYGLASS ? ConfigEnums.ZoomOverlays.SPYGLASS : ConfigEnums.ZoomOverlays.OFF));
        SPYGLASS_DEPENDENCY.set((Object)(preset == ZoomPresets.SPYGLASS ? ConfigEnums.SpyglassDependency.BOTH : ConfigEnums.SpyglassDependency.OFF));
        RESET_ZOOM_WITH_MOUSE.set((Object)(preset != ZoomPresets.CLASSIC ? 1 : 0));
        USE_SPYGLASS_TEXTURE.set((Object)(preset == ZoomPresets.SPYGLASS ? 1 : 0));
        USE_SPYGLASS_SOUNDS.set((Object)(preset == ZoomPresets.SPYGLASS ? 1 : 0));
        SHOW_RESTRICTION_TOASTS.set((Object)true);
        ZOOM_DIVISOR.set((Object)(switch (preset) {
            case ZoomPresets.PERSISTENT -> 1.0;
            case ZoomPresets.SPYGLASS -> 10.0;
            default -> 4.0;
        }));
        MINIMUM_ZOOM_DIVISOR.set((Object)1.0);
        MAXIMUM_LINEAR_STEP.set((Object)50.0);
        UPPER_SCROLL_STEPS.set((Object)(preset == ZoomPresets.SPYGLASS ? 16 : 20));
        LOWER_SCROLL_STEPS.set((Object)(preset == ZoomPresets.SPYGLASS ? 8 : 4));
        SMOOTH_MULTIPLIER.set((Object)(preset == ZoomPresets.SPYGLASS ? 0.5 : 0.75));
        CINEMATIC_MULTIPLIER.set((Object)4.0);
        MINIMUM_LINEAR_STEP.set((Object)0.125);
        MAXIMUM_LINEAR_STEP.set((Object)0.25);
        SPEC.save();
    }

    @SubscribeEvent
    static void configChanged(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() != ModConfig.Type.CLIENT) {
            return;
        }
        ZoomUtils.LOGGER.info("THe OkZoomer client config has been changed!");
        OkZoomerNetwork.configureZoomInstance();
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("features");
        CINEMATIC_CAMERA = builder.comment(new String[]{"Defines the cinematic camera while zooming.", "'OFF' disables the cinematic camera", "'VANILLA' uses Vanilla's cinematic camera.", "'MULTIPLIED' is a multiplied variant of 'VANILLA'"}).defineEnum("cinematic_camera", (Enum)ConfigEnums.CinematicCameraOptions.OFF);
        REDUCE_SENSITIVITY = builder.comment("Reduces the mouse sensitivity when zooming.").define("reduce_sensitivity", true);
        ZOOM_TRANSITION = builder.comment(new String[]{"Adds transitions between zooms.", "'OFF' disables transitions.", "'SMOOTH' replicates Vanilla's dynamic FOV.", "'LINEAR' removes the smoothiness."}).defineEnum("zoom_transition", (Enum)ConfigEnums.ZoomTransitionOptions.SMOOTH);
        ZOOM_MODE = builder.comment(new String[]{"The behavior of the zoom key.", "'HOLD' needs the zoom key to be hold.", "'TOGGLE' has the zoom key toggle the zoom.", "'PERSISTENT' makes the zoom permanent."}).defineEnum("zoom_mode", (Enum)ConfigEnums.ZoomModes.HOLD);
        ALLOW_SCROLLING = builder.comment("Allows to increase or decrease zoom by scrolling.").define("zoom_scrolling", true);
        EXTRA_KEY_BINDS = builder.comment(new String[]{"Adds zoom manipulation keys along with the zoom key.", "Note that this config will NOT prevent the keybinds from being registered, but they will become unusable if false."}).define("extra_key_binds", true);
        ZOOM_OVERLAY = builder.comment(new String[]{"Adds an overlay in the screen during zoom.", "'VIGNETTE' uses a vignette as the overlay.", "'SPYGLASS' uses the spyglass overlay with the vignette texture.", "The vignette texture can be found at: assets/okzoomer/textures/misc/zoom_overlay.png"}).defineEnum("zoom_overlay", (Enum)ConfigEnums.ZoomOverlays.OFF);
        SPYGLASS_DEPENDENCY = builder.comment(new String[]{"Determines how the zoom will depend on the spyglass.", "'REQUIRE_ITEM' will make zooming require a spyglass.", "'REPLACE_ZOOM' will replace spyglass's zoom with Ok Zoomer's zoom.", "'BOTH' will apply both options at the same time.", "The 'REQUIRE_ITEM' option is configurable through the okzoomer:zoom_dependencies item tag."}).defineEnum("spyglass_dependency", (Enum)ConfigEnums.SpyglassDependency.OFF);
        DISABLE_OVERLAY_NO_HUD = builder.comment("If the OkZoomer overlay should be disabled when the HUD is hidden. (F1 mode)").define("disable_overlay_no_hud", true);
        builder.pop();
        builder.push("values");
        ZOOM_DIVISOR = builder.comment("The divisor applied to the FOV when zooming.").defineInRange("zoom_divisor", 4.0, 0.0, Double.MAX_VALUE);
        MINIMUM_ZOOM_DIVISOR = builder.comment("The minimum value that you can scroll down.").defineInRange("minimum_zoom_divisor", 1.0, 0.0, Double.MAX_VALUE);
        MAXIMUM_ZOOM_DIVISOR = builder.comment("The maximum value that you can scroll down.").defineInRange("maximum_zoom_divisor", 50.0, 0.0, Double.MAX_VALUE);
        UPPER_SCROLL_STEPS = builder.comment(new String[]{"The number of steps between the zoom divisor and the maximum zoom divisor.", "Used by zoom scrolling."}).defineInRange("upper_scroll_steps", 20, 0, Integer.MAX_VALUE);
        LOWER_SCROLL_STEPS = builder.comment(new String[]{"The number of steps between the zoom divisor and the minimum zoom divisor.", "Used by zoom scrolling."}).defineInRange("lower_scroll_steps", 4, 0, Integer.MAX_VALUE);
        SMOOTH_MULTIPLIER = builder.comment("The multiplier used for smooth transitions.").defineInRange("smooth_multiplier", 0.75, -1.0, 1.0);
        CINEMATIC_MULTIPLIER = builder.comment("The multiplier used for the multiplied cinematic camera.").defineInRange("cinematic_multiplier", 4.0, -4.0, 4.0);
        MINIMUM_LINEAR_STEP = builder.comment("The minimum value that the linear transition step can reach.").defineInRange("minimum_linear_step", 0.125, 0.0, Double.MAX_VALUE);
        MAXIMUM_LINEAR_STEP = builder.comment("The maximum value that the linear transition step can reach.").defineInRange("maximum_linear_step", 0.25, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("tweaks");
        RESET_ZOOM_WITH_MOUSE = builder.comment("Allows resetting the zoom with the middle mouse button.").define("reset_zoom_with_mouse", true);
        USE_SPYGLASS_TEXTURE = builder.comment("If enabled, the spyglass overlay texture is used instead of Ok Zoomer's overlay texture.").define("use_spyglass_texture", false);
        USE_SPYGLASS_SOUNDS = builder.comment("If enabled, the zoom will use spyglass sounds on zooming in and out.").define("use_spyglass_sounds", false);
        SHOW_RESTRICTION_TOASTS = builder.comment("Shows toasts when the server imposes a restriction.").define("show_restriction_toasts", true);
        builder.pop();
        SPEC = builder.build();
    }

    public static enum ZoomPresets {
        DEFAULT,
        CLASSIC,
        PERSISTENT,
        SPYGLASS;

    }
}

