/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.okzoomer.api.transitions;

import com.matyrobbrt.okzoomer.api.TransitionMode;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SmoothTransitionMode
implements TransitionMode {
    private static final ResourceLocation TRANSITION_ID = new ResourceLocation("okzoomer", "smooth_transition");
    private boolean active = false;
    private final float smoothMultiplier;
    private double fovMultiplier;
    private float internalMultiplier;
    private float lastInternalMultiplier;

    public SmoothTransitionMode(float smoothMultiplier) {
        this.smoothMultiplier = smoothMultiplier;
        this.internalMultiplier = 1.0f;
        this.lastInternalMultiplier = 1.0f;
    }

    public SmoothTransitionMode() {
        this(0.5f);
    }

    @Override
    public ResourceLocation getId() {
        return TRANSITION_ID;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public double applyZoom(double fov, float tickDelta) {
        this.fovMultiplier = Mth.m_14179_((float)tickDelta, (float)this.lastInternalMultiplier, (float)this.internalMultiplier);
        return fov * this.fovMultiplier;
    }

    @Override
    public void tick(boolean active, double divisor) {
        double zoomMultiplier = 1.0 / divisor;
        this.lastInternalMultiplier = this.internalMultiplier;
        this.internalMultiplier = (float)((double)this.internalMultiplier + (zoomMultiplier - (double)this.internalMultiplier) * (double)this.smoothMultiplier);
        if (active || this.fovMultiplier == (double)this.internalMultiplier) {
            this.active = active;
        }
    }

    @Override
    public double getInternalMultiplier() {
        return this.internalMultiplier;
    }
}

