/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.okzoomer.api.modifiers;

import com.matyrobbrt.okzoomer.api.MouseModifier;
import net.minecraft.resources.ResourceLocation;

public class ContainingMouseModifier
implements MouseModifier {
    private static final ResourceLocation MODIFIER_ID = new ResourceLocation("okzoomer", "modifier_container");
    private boolean active = false;
    private final MouseModifier[] modifiers;

    public ContainingMouseModifier(MouseModifier ... modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public ResourceLocation getId() {
        return MODIFIER_ID;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public double applyXModifier(double cursorDeltaX, double cursorSensitivity, double mouseUpdateTimeDelta, double targetDivisor, double transitionMultiplier) {
        double returnedValue = cursorDeltaX;
        for (MouseModifier modifier : this.modifiers) {
            returnedValue = modifier.applyXModifier(returnedValue, cursorSensitivity, mouseUpdateTimeDelta, targetDivisor, transitionMultiplier);
        }
        return returnedValue;
    }

    @Override
    public double applyYModifier(double cursorDeltaY, double cursorSensitivity, double mouseUpdateTimeDelta, double targetDivisor, double transitionMultiplier) {
        double returnedValue = cursorDeltaY;
        for (MouseModifier modifier : this.modifiers) {
            returnedValue = modifier.applyYModifier(returnedValue, cursorSensitivity, mouseUpdateTimeDelta, targetDivisor, transitionMultiplier);
        }
        return returnedValue;
    }

    @Override
    public void tick(boolean active) {
        boolean generalActive = false;
        for (MouseModifier modifier : this.modifiers) {
            if (modifier == null) continue;
            modifier.tick(active);
            if (generalActive) continue;
            generalActive = modifier.getActive();
        }
        this.active = generalActive;
    }
}

