/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_chicken.content.components;

import com.mojang.math.Axis;
import com.oierbravo.create_mechanical_chicken.content.components.HalfShaftVisual;
import com.oierbravo.create_mechanical_chicken.content.components.MechanicalChickenBlockEntity;
import com.oierbravo.create_mechanical_chicken.foundation.blockEntity.behaviour.CycleBehavior;
import com.oierbravo.create_mechanical_chicken.registrate.ModPartials;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlock;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class MechanicalChickenVisual
extends HalfShaftVisual<MechanicalChickenBlockEntity>
implements SimpleDynamicVisual {
    private final OrientedInstance chickenHead;
    private final RotatingInstance cog;
    private final MechanicalChickenBlockEntity mechanicalChickenBlockEntity;
    final Direction horizontalDirection;
    private final Direction opposite;

    public MechanicalChickenVisual(VisualizationContext context, MechanicalChickenBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick, Direction.NORTH);
        this.horizontalDirection = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        this.opposite = this.horizontalDirection.m_122424_();
        this.mechanicalChickenBlockEntity = blockEntity;
        this.chickenHead = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)ModPartials.MECHANICAL_CHICKEN_HEAD)).createInstance();
        Quaternionf q = Axis.f_252436_.m_252977_(AngleHelper.horizontalAngle((Direction)((Direction)this.blockState.m_61143_(MechanicalPressBlock.HORIZONTAL_FACING)).m_122424_()));
        this.chickenHead.rotation((Quaternionfc)q);
        this.cog = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)ModPartials.MECHANICAL_CHICKEN_COG_HORIZONTAL)).createInstance();
        this.cog.setup((KineticBlockEntity)blockEntity).setPosition((Vec3i)this.getVisualPosition()).setChanged();
        this.transformModels(partialTick);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.transformModels(ctx.partialTick());
    }

    private void transformModels(float pt) {
        this.cog.setup((KineticBlockEntity)this.blockEntity).setChanged();
        float progress = this.getProgress(this.mechanicalChickenBlockEntity);
        float yPos = 0.0f;
        if (this.getProgress(this.mechanicalChickenBlockEntity) > 0.0f) {
            yPos = (float)Math.sin(progress) / 100.0f;
        }
        this.chickenHead.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, 0.3f + yPos, 0.0f).setChanged();
    }

    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(new FlatLit[]{this.cog});
        this.relight(this.pos, new FlatLit[]{this.chickenHead});
    }

    private float getProgress(MechanicalChickenBlockEntity pChickenBlockEntity) {
        CycleBehavior cycleBehavior = pChickenBlockEntity.getCycleBehaviour();
        return cycleBehavior.getProgress(AnimationTickHolder.getPartialTicks());
    }

    protected void _delete() {
        super._delete();
        this.cog.delete();
        this.chickenHead.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.cog);
        consumer.accept((Instance)this.chickenHead);
    }
}

