/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.processor.RandomSettings;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public class ApplyRandomStructureProcessor
extends StructureProcessor {
    private static final Codec<SimpleWeightedRandomList<Holder<StructureProcessorList>>> WEIGHTED_LIST_CODEC = SimpleWeightedRandomList.m_185860_((Codec)StructureProcessorType.f_74468_);
    private static final Codec<HolderSet<StructureProcessorList>> SET_CODEC = RegistryCodecs.m_206279_((ResourceKey)Registries.f_257011_, (Codec)StructureProcessorType.f_74467_);
    public static final Codec<ApplyRandomStructureProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LithostitchedCodecs.withAlternative(SET_CODEC, WEIGHTED_LIST_CODEC, ApplyRandomStructureProcessor::convertToSet).fieldOf("processor_lists").forGetter(ApplyRandomStructureProcessor::processorLists), (App)RandomSettings.CODEC.fieldOf("mode").forGetter(ApplyRandomStructureProcessor::randomSettings)).apply((Applicative)instance, ApplyRandomStructureProcessor::new));
    public static final StructureProcessorType<ApplyRandomStructureProcessor> TYPE = () -> CODEC;
    private final HolderSet<StructureProcessorList> processorLists;
    private final RandomSettings randomSettings;

    private static HolderSet<StructureProcessorList> convertToSet(SimpleWeightedRandomList<Holder<StructureProcessorList>> weightedList) {
        ArrayList<Holder> holders = new ArrayList<Holder>();
        for (WeightedEntry.Wrapper processor : weightedList.m_146338_()) {
            for (int i = 0; i < processor.m_142631_().m_146281_(); ++i) {
                holders.add((Holder)processor.m_146310_());
            }
        }
        return HolderSet.m_205800_(holders);
    }

    public ApplyRandomStructureProcessor(HolderSet<StructureProcessorList> processorLists, RandomSettings randomSettings) {
        this.processorLists = processorLists;
        this.randomSettings = randomSettings;
    }

    public HolderSet<StructureProcessorList> processorLists() {
        return this.processorLists;
    }

    public RandomSettings randomSettings() {
        return this.randomSettings;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo relative, StructureTemplate.StructureBlockInfo absolute, StructurePlaceSettings settings) {
        if (levelReader instanceof WorldGenLevel) {
            WorldGenLevel level = (WorldGenLevel)levelReader;
            RandomSource random = this.randomSettings.create(level, pos, absolute);
            if (this.processorLists.m_203632_() > 0) {
                StructureProcessor processor;
                Holder processorList = this.processorLists.m_203662_(random.m_188503_(this.processorLists.m_203632_()));
                StructureTemplate.StructureBlockInfo processedBlock = absolute;
                Iterator iterator = ((StructureProcessorList)processorList.m_203334_()).m_74425_().iterator();
                while (iterator.hasNext() && (processedBlock = (processor = (StructureProcessor)iterator.next()).m_7382_(levelReader, pos, pivot, relative, processedBlock, settings)) != null) {
                }
                return processedBlock;
            }
        }
        return absolute;
    }

    @NotNull
    protected StructureProcessorType<?> m_6953_() {
        return TYPE;
    }
}

