/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks;

import com.pedrorok.hypertube.blocks.HypertubeBlock;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnectionEntity;
import com.pedrorok.hypertube.registry.ModBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TubeBlock
extends KineticBlock
implements ITubeConnection,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public TubeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public abstract VoxelShape getShape(BlockState var1, @Nullable CollisionContext var2);

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShape(state, context);
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShape(state, context);
    }

    @NotNull
    public VoxelShape m_7947_(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return this.getShape(state);
    }

    @NotNull
    public VoxelShape m_6079_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        return this.getShape(state);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state) {
        return this.getShape(state, null);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return null;
    }

    @NotNull
    public BlockState m_7417_(BlockState p_313906_, @NotNull Direction p_313739_, @NotNull BlockState p_313829_, @NotNull LevelAccessor p_313692_, @NotNull BlockPos p_313842_, @NotNull BlockPos p_313843_) {
        if (((Boolean)p_313906_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_313692_.m_186469_(p_313842_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_313692_));
        }
        return super.m_7417_(p_313906_, p_313739_, p_313829_, p_313692_, p_313842_, p_313843_);
    }

    @NotNull
    public FluidState m_5888_(BlockState p_313789_) {
        return (Boolean)p_313789_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(true) : super.m_5888_(p_313789_);
    }

    public abstract Item getItem();

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.getItem().m_7968_();
    }

    public ItemStack m_7397_(BlockGetter p_49823_, BlockPos p_49824_, BlockState p_49825_) {
        return this.getItem().m_7968_();
    }

    @NotNull
    public void m_5707_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        this.playerWillDestroy(level, pos, state, player, false);
    }

    void playerWillDestroy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player, boolean wrenched) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof ITubeConnectionEntity)) {
            super.m_5707_(level, pos, state, player);
            return;
        }
        ITubeConnectionEntity tube = (ITubeConnectionEntity)blockEntity;
        int toDrop = tube.blockBroken();
        if (wrenched) {
            if (this instanceof HypertubeBlock) {
                ++toDrop;
            } else {
                player.m_150109_().m_150079_(this.getItem().m_7968_());
            }
        }
        if (!player.m_7500_() && (toDrop != 0 || wrenched)) {
            ItemStack stack = new ItemStack((ItemLike)ModBlocks.HYPERTUBE.get(), toDrop);
            if (wrenched) {
                player.m_150109_().m_150079_(stack);
            } else {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        this.playerWillDestroy(world, context.m_8083_(), state, context.m_43723_(), true);
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, world.m_8055_(pos), player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return InteractionResult.SUCCESS;
        }
        world.m_46961_(pos, false);
        IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean canTravelConnect(LevelAccessor world, BlockPos posSelf, Direction facing) {
        TubeBlock hypertubeBlock;
        BlockPos relative = posSelf.m_121945_(facing);
        BlockState otherState = world.m_8055_(relative);
        Block block = otherState.m_60734_();
        return block instanceof ITubeConnection && (!(block instanceof TubeBlock) || this.canOtherConnectTo(otherState, hypertubeBlock = (TubeBlock)block, facing));
    }

    private boolean canOtherConnectTo(BlockState otherState, TubeBlock otherTube, Direction facing) {
        List connectedFaces = otherTube.getConnectedFaces(otherState);
        return connectedFaces.isEmpty() || connectedFaces.contains(facing);
    }
}

