/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.core.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.teamabnormals.autumnity.common.block.TallFoulBerryBushBlock;
import com.teamabnormals.autumnity.common.levelgen.feature.FallenLeavesFeature;
import com.teamabnormals.autumnity.common.levelgen.feature.FallenLeavesMapleTreeFeature;
import com.teamabnormals.autumnity.common.levelgen.feature.MapleTreeFeature;
import com.teamabnormals.autumnity.common.levelgen.feature.PumpkinFieldsPumpkinFeature;
import com.teamabnormals.autumnity.common.levelgen.placement.BetterNoiseBasedCountPlacement;
import com.teamabnormals.autumnity.core.registry.AutumnityBlocks;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AutumnityFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"autumnity");
    public static final RegistryObject<Feature<TreeConfiguration>> MAPLE_TREE = FEATURES.register("maple_tree", () -> new MapleTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));
    public static final RegistryObject<Feature<TreeConfiguration>> FALLEN_LEAVES_MAPLE_TREE = FEATURES.register("fallen_leaves_maple_tree", () -> new FallenLeavesMapleTreeFeature((Codec<TreeConfiguration>)TreeConfiguration.f_68184_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> FALLEN_LEAVES = FEATURES.register("fallen_leaves", () -> new FallenLeavesFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> PUMPKIN_FIELDS_PUMPKIN = FEATURES.register("pumpkin_fields_pumpkin", () -> new PumpkinFieldsPumpkinFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));

    public static final class AutumnityPlacedFeatures {
        public static final ResourceKey<PlacedFeature> MAPLE_TREE_CHECKED = AutumnityPlacedFeatures.createKey("maple_tree_checked");
        public static final ResourceKey<PlacedFeature> RED_MAPLE_TREE_CHECKED = AutumnityPlacedFeatures.createKey("red_maple_tree_checked");
        public static final ResourceKey<PlacedFeature> FALLEN_LEAVES_YELLOW_MAPLE_TREE_CHECKED = AutumnityPlacedFeatures.createKey("fallen_leaves_yellow_maple_tree_checked");
        public static final ResourceKey<PlacedFeature> FALLEN_LEAVES_ORANGE_MAPLE_TREE_CHECKED = AutumnityPlacedFeatures.createKey("fallen_leaves_orange_maple_tree_checked");
        public static final ResourceKey<PlacedFeature> TREES_MAPLE = AutumnityPlacedFeatures.createKey("trees_maple");
        public static final ResourceKey<PlacedFeature> TREES_MAPLE_YELLOW = AutumnityPlacedFeatures.createKey("trees_maple_yellow");
        public static final ResourceKey<PlacedFeature> TREES_MAPLE_ORANGE = AutumnityPlacedFeatures.createKey("trees_maple_orange");
        public static final ResourceKey<PlacedFeature> TREES_MAPLE_RED = AutumnityPlacedFeatures.createKey("trees_maple_red");
        public static final ResourceKey<PlacedFeature> FALLEN_LEAVES = AutumnityPlacedFeatures.createKey("fallen_leaves");
        public static final ResourceKey<PlacedFeature> PATCH_FOUL_BERRY_BUSH = AutumnityPlacedFeatures.createKey("patch_foul_berry_bush");
        public static final ResourceKey<PlacedFeature> FLOWER_MAPLE_FOREST = AutumnityPlacedFeatures.createKey("flower_maple_forest");
        public static final ResourceKey<PlacedFeature> MAPLE_FOREST_VEGETATION = AutumnityPlacedFeatures.createKey("maple_forest_vegetation");
        public static final ResourceKey<PlacedFeature> PUMPKIN_FIELDS_VEGETATION = AutumnityPlacedFeatures.createKey("pumpkin_fields_vegetation");
        public static final ResourceKey<PlacedFeature> PATCH_TALL_GRASS_PUMPKIN_FIELDS = AutumnityPlacedFeatures.createKey("patch_tall_grass_pumpkin_fields");
        public static final ResourceKey<PlacedFeature> PATCH_PUMPKIN_PUMPKIN_FIELDS = AutumnityPlacedFeatures.createKey("patch_pumpkin_pumpkin_fields");
        public static final ResourceKey<PlacedFeature> FLOWER_PUMPKIN_FIELDS = AutumnityPlacedFeatures.createKey("flower_pumpkin_fields");

        public static void bootstrap(BootstapContext<PlacedFeature> context) {
            HolderGetter noise = context.m_255420_(Registries.f_256865_);
            AutumnityPlacedFeatures.register(context, MAPLE_TREE_CHECKED, AutumnityConfiguredFeatures.MAPLE_TREE, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
            AutumnityPlacedFeatures.register(context, RED_MAPLE_TREE_CHECKED, AutumnityConfiguredFeatures.MAPLE_TREE_RED, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
            AutumnityPlacedFeatures.register(context, FALLEN_LEAVES_YELLOW_MAPLE_TREE_CHECKED, AutumnityConfiguredFeatures.FALLEN_LEAVES_MAPLE_TREE_YELLOW, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
            AutumnityPlacedFeatures.register(context, FALLEN_LEAVES_ORANGE_MAPLE_TREE_CHECKED, AutumnityConfiguredFeatures.FALLEN_LEAVES_MAPLE_TREE_ORANGE, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
            AutumnityPlacedFeatures.register(context, TREES_MAPLE, AutumnityConfiguredFeatures.MAPLE_TREE, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)1, (float)0.1f, (int)1)));
            BetterNoiseBasedCountPlacement spottedMaplesCount = new BetterNoiseBasedCountPlacement((Holder<NormalNoise.NoiseParameters>)((Holder)noise.m_254902_(AutumnityNoiseParameters.SPOTTED_MAPLES).get()), 12, -0.4f);
            AutumnityPlacedFeatures.register(context, TREES_MAPLE_YELLOW, AutumnityConfiguredFeatures.MAPLE_TREE_YELLOW, (List<PlacementModifier>)AutumnityPlacedFeatures.treePlacementBase(spottedMaplesCount).build());
            AutumnityPlacedFeatures.register(context, TREES_MAPLE_ORANGE, AutumnityConfiguredFeatures.MAPLE_TREE_ORANGE, (List<PlacementModifier>)AutumnityPlacedFeatures.treePlacementBase(spottedMaplesCount).build());
            AutumnityPlacedFeatures.register(context, TREES_MAPLE_RED, AutumnityConfiguredFeatures.MAPLE_TREE_RED, (List<PlacementModifier>)AutumnityPlacedFeatures.treePlacementBase(spottedMaplesCount).build());
            AutumnityPlacedFeatures.register(context, FALLEN_LEAVES, AutumnityConfiguredFeatures.FALLEN_LEAVES, new PlacementModifier[]{RarityFilter.m_191900_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
            AutumnityPlacedFeatures.register(context, PATCH_FOUL_BERRY_BUSH, AutumnityConfiguredFeatures.PATCH_FOUL_BERRY_BUSH, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
            AutumnityPlacedFeatures.register(context, FLOWER_MAPLE_FOREST, AutumnityConfiguredFeatures.FLOWER_MAPLE_FOREST, new PlacementModifier[]{RarityFilter.m_191900_((int)7), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
            AutumnityPlacedFeatures.register(context, MAPLE_FOREST_VEGETATION, AutumnityConfiguredFeatures.MAPLE_FOREST_VEGETATION, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)10, (float)0.1f, (int)1)));
            AutumnityPlacedFeatures.register(context, PUMPKIN_FIELDS_VEGETATION, AutumnityConfiguredFeatures.MAPLE_FOREST_VEGETATION, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)2, (float)0.2f, (int)1)));
            AutumnityPlacedFeatures.register(context, PATCH_TALL_GRASS_PUMPKIN_FIELDS, AutumnityConfiguredFeatures.PATCH_TALL_GRASS, new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)5, (int)10), RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
            AutumnityPlacedFeatures.register(context, PATCH_PUMPKIN_PUMPKIN_FIELDS, AutumnityConfiguredFeatures.PATCH_PUMPKINS_PUMPKIN_FIELDS, new PlacementModifier[]{RarityFilter.m_191900_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
            AutumnityPlacedFeatures.register(context, FLOWER_PUMPKIN_FIELDS, AutumnityConfiguredFeatures.FLOWER_PUMPKIN_FIELDS, new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)15, (int)4), RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        }

        private static ImmutableList.Builder<PlacementModifier> treePlacementBase(PlacementModifier modifier) {
            return ImmutableList.builder().add((Object)modifier).add((Object)InSquarePlacement.m_191715_()).add((Object)SurfaceWaterDepthFilter.m_191950_((int)0)).add((Object)PlacementUtils.f_195355_).add((Object)BiomeFilter.m_191561_());
        }

        public static ResourceKey<PlacedFeature> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("autumnity", name));
        }

        public static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> modifiers) {
            context.m_255272_(key, (Object)new PlacedFeature((Holder)context.m_255420_(Registries.f_256911_).m_255043_(feature), modifiers));
        }

        public static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> feature, PlacementModifier ... modifiers) {
            AutumnityPlacedFeatures.register(context, key, feature, List.of(modifiers));
        }
    }

    public static final class AutumnityConfiguredFeatures {
        public static final ResourceKey<ConfiguredFeature<?, ?>> MAPLE_TREE = AutumnityConfiguredFeatures.createKey("maple_tree");
        public static final ResourceKey<ConfiguredFeature<?, ?>> MAPLE_TREE_YELLOW = AutumnityConfiguredFeatures.createKey("maple_tree_yellow");
        public static final ResourceKey<ConfiguredFeature<?, ?>> MAPLE_TREE_ORANGE = AutumnityConfiguredFeatures.createKey("maple_tree_orange");
        public static final ResourceKey<ConfiguredFeature<?, ?>> MAPLE_TREE_RED = AutumnityConfiguredFeatures.createKey("maple_tree_red");
        public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_LEAVES_MAPLE_TREE_YELLOW = AutumnityConfiguredFeatures.createKey("fallen_leaves_maple_tree_yellow");
        public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_LEAVES_MAPLE_TREE_ORANGE = AutumnityConfiguredFeatures.createKey("fallen_leaves_maple_tree_orange");
        public static final ResourceKey<ConfiguredFeature<?, ?>> FALLEN_LEAVES = AutumnityConfiguredFeatures.createKey("fallen_leaves");
        public static final ResourceKey<ConfiguredFeature<?, ?>> MAPLE_FOREST_VEGETATION = AutumnityConfiguredFeatures.createKey("maple_forest_vegetation");
        public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_TALL_GRASS = AutumnityConfiguredFeatures.createKey("patch_tall_grass");
        public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_FOUL_BERRY_BUSH = AutumnityConfiguredFeatures.createKey("patch_foul_berry_bush");
        public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_PUMPKINS_PUMPKIN_FIELDS = AutumnityConfiguredFeatures.createKey("patch_pumpkins_pumpkin_fields");
        public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWER_MAPLE_FOREST = AutumnityConfiguredFeatures.createKey("flower_maple_forest");
        public static final ResourceKey<ConfiguredFeature<?, ?>> FLOWER_PUMPKIN_FIELDS = AutumnityConfiguredFeatures.createKey("flower_pumpkin_fields");

        public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
            HolderGetter configuredFeatures = context.m_255420_(Registries.f_256911_);
            HolderGetter placedFeatures = context.m_255420_(Registries.f_256988_);
            AutumnityConfiguredFeatures.register(context, MAPLE_TREE, (Feature)MAPLE_TREE.get(), Configs.MAPLE_TREE_CONFIG);
            AutumnityConfiguredFeatures.register(context, MAPLE_TREE_YELLOW, (Feature)MAPLE_TREE.get(), Configs.YELLOW_MAPLE_TREE_CONFIG);
            AutumnityConfiguredFeatures.register(context, MAPLE_TREE_ORANGE, (Feature)MAPLE_TREE.get(), Configs.ORANGE_MAPLE_TREE_CONFIG);
            AutumnityConfiguredFeatures.register(context, MAPLE_TREE_RED, (Feature)MAPLE_TREE.get(), Configs.RED_MAPLE_TREE_CONFIG);
            AutumnityConfiguredFeatures.register(context, FALLEN_LEAVES_MAPLE_TREE_YELLOW, (Feature)FALLEN_LEAVES_MAPLE_TREE.get(), Configs.YELLOW_MAPLE_TREE_CONFIG);
            AutumnityConfiguredFeatures.register(context, FALLEN_LEAVES_MAPLE_TREE_ORANGE, (Feature)FALLEN_LEAVES_MAPLE_TREE.get(), Configs.ORANGE_MAPLE_TREE_CONFIG);
            AutumnityConfiguredFeatures.register(context, FALLEN_LEAVES, (Feature)FALLEN_LEAVES.get(), FeatureConfiguration.f_67737_);
            AutumnityConfiguredFeatures.register(context, MAPLE_FOREST_VEGETATION, Feature.f_65754_, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.m_206506_((Holder)configuredFeatures.m_255043_(TreeFeatures.f_195121_), (PlacementModifier[])new PlacementModifier[0]), 0.025f), new WeightedPlacedFeature(PlacementUtils.m_206506_((Holder)configuredFeatures.m_255043_(TreeFeatures.f_195122_), (PlacementModifier[])new PlacementModifier[0]), 0.05f), new WeightedPlacedFeature((Holder)placedFeatures.m_255043_(AutumnityPlacedFeatures.RED_MAPLE_TREE_CHECKED), 0.3f), new WeightedPlacedFeature((Holder)placedFeatures.m_255043_(AutumnityPlacedFeatures.FALLEN_LEAVES_ORANGE_MAPLE_TREE_CHECKED), 0.4f), new WeightedPlacedFeature((Holder)placedFeatures.m_255043_(AutumnityPlacedFeatures.FALLEN_LEAVES_YELLOW_MAPLE_TREE_CHECKED), 0.2f)), (Holder)placedFeatures.m_255043_(AutumnityPlacedFeatures.MAPLE_TREE_CHECKED)));
            AutumnityConfiguredFeatures.register(context, PATCH_TALL_GRASS, Feature.f_65763_, FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50359_))));
            AutumnityConfiguredFeatures.register(context, PATCH_FOUL_BERRY_BUSH, Feature.f_65763_, FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)AutumnityBlocks.TALL_FOUL_BERRY_BUSH.get()).m_49966_().m_61124_((Property)TallFoulBerryBushBlock.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.f_50440_)));
            AutumnityConfiguredFeatures.register(context, PATCH_PUMPKINS_PUMPKIN_FIELDS, (Feature)PUMPKIN_FIELDS_PUMPKIN.get(), FeatureConfiguration.f_67737_);
            AutumnityConfiguredFeatures.register(context, FLOWER_MAPLE_FOREST, Feature.f_65755_, new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50357_))), (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65762_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)AutumnityBlocks.AUTUMN_CROCUS.get())))), (PlacementModifier[])new PlacementModifier[0])})));
            AutumnityConfiguredFeatures.register(context, FLOWER_PUMPKIN_FIELDS, Feature.f_65761_, FeatureUtils.m_206470_((int)64, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)AutumnityBlocks.AUTUMN_CROCUS.get()).m_49966_(), 1).m_146271_((Object)Blocks.f_50120_.m_49966_(), 1).m_146271_((Object)Blocks.f_50121_.m_49966_(), 1))))));
        }

        public static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("autumnity", name));
        }

        public static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC config) {
            context.m_255272_(key, (Object)new ConfiguredFeature(feature, config));
        }
    }

    public static final class AutumnityNoiseParameters {
        public static final ResourceKey<NormalNoise.NoiseParameters> SPOTTED_MAPLES = AutumnityNoiseParameters.createKey("spotted_maples");

        public static void bootstrap(BootstapContext<NormalNoise.NoiseParameters> context) {
            context.m_255272_(SPOTTED_MAPLES, (Object)new NormalNoise.NoiseParameters(-8, 1.0, new double[0]));
        }

        public static ResourceKey<NormalNoise.NoiseParameters> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256865_, (ResourceLocation)new ResourceLocation("autumnity", name));
        }
    }

    public static final class Configs {
        public static final TreeConfiguration MAPLE_TREE_CONFIG = Configs.createMaple(States.MAPLE_LEAVES).m_68251_();
        public static final TreeConfiguration YELLOW_MAPLE_TREE_CONFIG = Configs.createMaple(States.YELLOW_MAPLE_LEAVES).m_68251_();
        public static final TreeConfiguration ORANGE_MAPLE_TREE_CONFIG = Configs.createMaple(States.ORANGE_MAPLE_LEAVES).m_68251_();
        public static final TreeConfiguration RED_MAPLE_TREE_CONFIG = Configs.createMaple(States.RED_MAPLE_LEAVES).m_68251_();

        private static TreeConfiguration.TreeConfigurationBuilder createMaple(BlockState leavesState) {
            return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)States.MAPLE_LOG), (TrunkPlacer)new StraightTrunkPlacer(5, 1, 0), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)leavesState), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0), 0), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0)).m_68244_();
        }
    }

    public static final class States {
        private static final BlockState MAPLE_LOG = ((Block)AutumnityBlocks.MAPLE_LOG.get()).m_49966_();
        private static final BlockState MAPLE_LEAVES = ((Block)AutumnityBlocks.MAPLE_LEAVES.get()).m_49966_();
        private static final BlockState YELLOW_MAPLE_LEAVES = ((Block)AutumnityBlocks.YELLOW_MAPLE_LEAVES.get()).m_49966_();
        private static final BlockState ORANGE_MAPLE_LEAVES = ((Block)AutumnityBlocks.ORANGE_MAPLE_LEAVES.get()).m_49966_();
        private static final BlockState RED_MAPLE_LEAVES = ((Block)AutumnityBlocks.RED_MAPLE_LEAVES.get()).m_49966_();
    }
}

