/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.autumnity.core.data.server.modifiers;

import com.teamabnormals.autumnity.core.registry.AutumnityBiomes;
import com.teamabnormals.autumnity.core.registry.AutumnityBlocks;
import com.teamabnormals.autumnity.core.registry.AutumnityEntityTypes;
import com.teamabnormals.autumnity.core.registry.AutumnityItems;
import com.teamabnormals.autumnity.core.registry.AutumnityMobEffects;
import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierProvider;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.CriteriaModifier;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.EffectsChangedModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.BredAnimalsTrigger;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public class AutumnityAdvancementModifierProvider
extends AdvancementModifierProvider {
    private static final EntityType<?>[] BREEDABLE_ANIMALS = new EntityType[]{(EntityType)AutumnityEntityTypes.SNAIL.get(), (EntityType)AutumnityEntityTypes.TURKEY.get()};

    public AutumnityAdvancementModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("autumnity", output, provider);
    }

    protected void registerEntries(HolderLookup.Provider provider) {
        this.entry("nether/all_potions").selects(new String[]{"nether/all_potions"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, MobEffectsPredicate.m_56552_().m_56553_((MobEffect)AutumnityMobEffects.EXTENSION.get())), new ICondition[0]);
        this.entry("nether/all_effects").selects(new String[]{"nether/all_effects"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, MobEffectsPredicate.m_56552_().m_56553_((MobEffect)AutumnityMobEffects.EXTENSION.get()).m_56553_((MobEffect)AutumnityMobEffects.FOUL_TASTE.get())), new ICondition[0]);
        CriteriaModifier.Builder balancedDiet = CriteriaModifier.builder((String)this.modId);
        AutumnityItems.HELPER.getDeferredRegister().getEntries().forEach(registryObject -> {
            Item item = (Item)registryObject.get();
            if (item.m_41472_()) {
                balancedDiet.addCriterion(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_(), (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)item));
            }
        });
        this.entry("husbandry/balanced_diet").selects(new String[]{"husbandry/balanced_diet"}).addModifier((ObjectModifier)balancedDiet.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
        CriteriaModifier.Builder adventuringTime = CriteriaModifier.builder((String)this.modId);
        for (ResourceKey<Biome> biome : List.of(AutumnityBiomes.MAPLE_FOREST, AutumnityBiomes.PUMPKIN_FIELDS)) {
            adventuringTime.addCriterion(biome.m_135782_().toString(), (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(biome)));
        }
        this.entry("adventure/adventuring_time").selects(new String[]{"adventure/adventuring_time"}).addModifier((ObjectModifier)adventuringTime.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
        this.entry("husbandry/plant_seed").selects(new String[]{"husbandry/plant_seed"}).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion("foul_berry_bush_pips", (CriterionTriggerInstance)ItemUsedOnLocationTrigger.TriggerInstance.m_286031_((Block)((Block)AutumnityBlocks.FOUL_BERRY_BUSH.get()))).addIndexedRequirements(0, false, new String[]{"foul_berry_bush_pips"}).build(), new ICondition[0]);
        CriteriaModifier.Builder breedAllAnimals = CriteriaModifier.builder((String)this.modId);
        for (EntityType<?> entityType : BREEDABLE_ANIMALS) {
            breedAllAnimals.addCriterion(ForgeRegistries.ENTITY_TYPES.getKey(entityType).m_135815_(), (CriterionTriggerInstance)BredAnimalsTrigger.TriggerInstance.m_18667_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(entityType)));
        }
        this.entry("husbandry/bred_all_animals").selects(new String[]{"husbandry/bred_all_animals"}).addModifier((ObjectModifier)breedAllAnimals.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
    }
}

